/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.util;

import com.github.tmurakami.dexopener.repackaged.org.jf.util.AbstractListIterator;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractForwardSequentialList<T>
extends AbstractSequentialList<T> {
    @Nonnull
    private Iterator<T> iterator(int index) {
        if (index < 0) {
            throw new NoSuchElementException();
        }
        Iterator<T> it = this.iterator();
        for (int i = 0; i < index; ++i) {
            it.next();
        }
        return it;
    }

    @Override
    @Nonnull
    public abstract Iterator<T> iterator();

    @Override
    @Nonnull
    public ListIterator<T> listIterator(final int initialIndex) {
        Iterator<T> initialIterator;
        try {
            initialIterator = this.iterator(initialIndex);
        }
        catch (NoSuchElementException ex) {
            throw new IndexOutOfBoundsException();
        }
        return new AbstractListIterator<T>(){
            private int index;
            @Nullable
            private Iterator<T> forwardIterator;
            {
                this.index = initialIndex - 1;
                this.forwardIterator = initialIterator;
            }

            @Nonnull
            private Iterator<T> getForwardIterator() {
                if (this.forwardIterator == null) {
                    try {
                        this.forwardIterator = AbstractForwardSequentialList.this.iterator(this.index + 1);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new NoSuchElementException();
                    }
                }
                return this.forwardIterator;
            }

            @Override
            public boolean hasNext() {
                return this.getForwardIterator().hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.index >= 0;
            }

            @Override
            public T next() {
                Object ret = this.getForwardIterator().next();
                ++this.index;
                return ret;
            }

            @Override
            public int nextIndex() {
                return this.index + 1;
            }

            @Override
            public T previous() {
                this.forwardIterator = null;
                try {
                    return AbstractForwardSequentialList.this.iterator(this.index--).next();
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int previousIndex() {
                return this.index;
            }
        };
    }

    @Override
    @Nonnull
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }
}

