/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterables;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterators;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Ordering;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseTypeReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Field;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.PoolMethod;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.TypeListPool;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class PoolClassDef
extends BaseTypeReference
implements ClassDef {
    @Nonnull
    final ClassDef classDef;
    @Nonnull
    final TypeListPool.Key<List<String>> interfaces;
    @Nonnull
    final ImmutableSortedSet<Field> staticFields;
    @Nonnull
    final ImmutableSortedSet<Field> instanceFields;
    @Nonnull
    final ImmutableSortedSet<PoolMethod> directMethods;
    @Nonnull
    final ImmutableSortedSet<PoolMethod> virtualMethods;
    int classDefIndex = -1;
    int encodedArrayOffset = 0;
    int annotationDirectoryOffset = 0;

    PoolClassDef(@Nonnull ClassDef classDef) {
        this.classDef = classDef;
        this.interfaces = new TypeListPool.Key<ImmutableList<String>>(ImmutableList.copyOf(classDef.getInterfaces()));
        this.staticFields = ImmutableSortedSet.copyOf(classDef.getStaticFields());
        this.instanceFields = ImmutableSortedSet.copyOf(classDef.getInstanceFields());
        this.directMethods = ImmutableSortedSet.copyOf(Iterables.transform(classDef.getDirectMethods(), PoolMethod.TRANSFORM));
        this.virtualMethods = ImmutableSortedSet.copyOf(Iterables.transform(classDef.getVirtualMethods(), PoolMethod.TRANSFORM));
    }

    @Override
    @Nonnull
    public String getType() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.classDef.getAccessFlags();
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.classDef.getSuperclass();
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        return (List)this.interfaces.types;
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.classDef.getSourceFile();
    }

    @Override
    @Nonnull
    public Set<? extends Annotation> getAnnotations() {
        return this.classDef.getAnnotations();
    }

    @Nonnull
    public SortedSet<Field> getStaticFields() {
        return this.staticFields;
    }

    @Nonnull
    public SortedSet<Field> getInstanceFields() {
        return this.instanceFields;
    }

    @Nonnull
    public Collection<Field> getFields() {
        return new AbstractCollection<Field>(){

            @Override
            @Nonnull
            public Iterator<Field> iterator() {
                return Iterators.mergeSorted(ImmutableList.of(PoolClassDef.this.staticFields.iterator(), PoolClassDef.this.instanceFields.iterator()), Ordering.natural());
            }

            @Override
            public int size() {
                return PoolClassDef.this.staticFields.size() + PoolClassDef.this.instanceFields.size();
            }
        };
    }

    @Nonnull
    public SortedSet<PoolMethod> getDirectMethods() {
        return this.directMethods;
    }

    @Nonnull
    public SortedSet<PoolMethod> getVirtualMethods() {
        return this.virtualMethods;
    }

    @Nonnull
    public Collection<PoolMethod> getMethods() {
        return new AbstractCollection<PoolMethod>(){

            @Override
            @Nonnull
            public Iterator<PoolMethod> iterator() {
                return Iterators.mergeSorted(ImmutableList.of(PoolClassDef.this.directMethods.iterator(), PoolClassDef.this.virtualMethods.iterator()), Ordering.natural());
            }

            @Override
            public int size() {
                return PoolClassDef.this.directMethods.size() + PoolClassDef.this.virtualMethods.size();
            }
        };
    }
}

