/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.AnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Field;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.FieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodProtoReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.StringReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.TypeReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ArrayEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.BooleanEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ByteEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.CharEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.DoubleEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EnumEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.FieldEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.FloatEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.IntEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.LongEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.MethodEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ShortEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.StringEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.TypeEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.DexWriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.AnnotationPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.AnnotationSetPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.ClassPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.FieldPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.Markable;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.MethodPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.PoolClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.PoolMethod;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.ProtoPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.StringPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.TypeListPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.TypePool;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public class DexPool
extends DexWriter<CharSequence, StringReference, CharSequence, TypeReference, MethodProtoReference, FieldReference, MethodReference, PoolClassDef, Annotation, Set<? extends Annotation>, TypeListPool.Key<? extends Collection<? extends CharSequence>>, Field, PoolMethod, EncodedValue, AnnotationElement, StringPool, TypePool, ProtoPool, FieldPool, MethodPool, ClassPool, TypeListPool, AnnotationPool, AnnotationSetPool> {
    private final Markable[] sections;

    public DexPool(Opcodes opcodes) {
        super(opcodes);
        this.sections = new Markable[]{(Markable)((Object)this.stringSection), (Markable)((Object)this.typeSection), (Markable)((Object)this.protoSection), (Markable)((Object)this.fieldSection), (Markable)((Object)this.methodSection), (Markable)((Object)this.classSection), (Markable)((Object)this.typeListSection), (Markable)((Object)this.annotationSection), (Markable)((Object)this.annotationSetSection)};
    }

    @Override
    @Nonnull
    protected DexWriter.SectionProvider getSectionProvider() {
        return new DexPoolSectionProvider();
    }

    public void internClass(ClassDef classDef) {
        ((ClassPool)this.classSection).intern(classDef);
    }

    @Override
    protected void writeEncodedValue(@Nonnull DexWriter.InternalEncodedValueWriter writer, @Nonnull EncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                writer.writeAnnotation(annotationEncodedValue.getType(), annotationEncodedValue.getElements());
                break;
            }
            case 28: {
                ArrayEncodedValue arrayEncodedValue = (ArrayEncodedValue)encodedValue;
                writer.writeArray(arrayEncodedValue.getValue());
                break;
            }
            case 31: {
                writer.writeBoolean(((BooleanEncodedValue)encodedValue).getValue());
                break;
            }
            case 0: {
                writer.writeByte(((ByteEncodedValue)encodedValue).getValue());
                break;
            }
            case 3: {
                writer.writeChar(((CharEncodedValue)encodedValue).getValue());
                break;
            }
            case 17: {
                writer.writeDouble(((DoubleEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                writer.writeEnum(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                writer.writeField(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 16: {
                writer.writeFloat(((FloatEncodedValue)encodedValue).getValue());
                break;
            }
            case 4: {
                writer.writeInt(((IntEncodedValue)encodedValue).getValue());
                break;
            }
            case 6: {
                writer.writeLong(((LongEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                writer.writeMethod(((MethodEncodedValue)encodedValue).getValue());
                break;
            }
            case 30: {
                writer.writeNull();
                break;
            }
            case 2: {
                writer.writeShort(((ShortEncodedValue)encodedValue).getValue());
                break;
            }
            case 23: {
                writer.writeString(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                writer.writeType(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            default: {
                throw new ExceptionWithContext("Unrecognized value type: %d", encodedValue.getValueType());
            }
        }
    }

    void internEncodedValue(@Nonnull EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                ((TypePool)this.typeSection).intern(annotationEncodedValue.getType());
                for (AnnotationElement annotationElement : annotationEncodedValue.getElements()) {
                    ((StringPool)this.stringSection).intern(annotationElement.getName());
                    this.internEncodedValue(annotationElement.getValue());
                }
                break;
            }
            case 28: {
                for (EncodedValue encodedValue2 : ((ArrayEncodedValue)encodedValue).getValue()) {
                    this.internEncodedValue(encodedValue2);
                }
                break;
            }
            case 23: {
                ((StringPool)this.stringSection).intern(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                ((TypePool)this.typeSection).intern(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                ((FieldPool)this.fieldSection).intern(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                ((FieldPool)this.fieldSection).intern(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                ((MethodPool)this.methodSection).intern(((MethodEncodedValue)encodedValue).getValue());
            }
        }
    }

    protected class DexPoolSectionProvider
    extends DexWriter.SectionProvider {
        protected DexPoolSectionProvider() {
        }

        @Nonnull
        public StringPool getStringSection() {
            return new StringPool(DexPool.this);
        }

        @Nonnull
        public TypePool getTypeSection() {
            return new TypePool(DexPool.this);
        }

        @Nonnull
        public ProtoPool getProtoSection() {
            return new ProtoPool(DexPool.this);
        }

        @Nonnull
        public FieldPool getFieldSection() {
            return new FieldPool(DexPool.this);
        }

        @Nonnull
        public MethodPool getMethodSection() {
            return new MethodPool(DexPool.this);
        }

        @Nonnull
        public ClassPool getClassSection() {
            return new ClassPool(DexPool.this);
        }

        @Nonnull
        public TypeListPool getTypeListSection() {
            return new TypeListPool(DexPool.this);
        }

        @Nonnull
        public AnnotationPool getAnnotationSection() {
            return new AnnotationPool(DexPool.this);
        }

        @Nonnull
        public AnnotationSetPool getAnnotationSetSection() {
            return new AnnotationSetPool(DexPool.this);
        }
    }
}

