/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.raw.HeaderItem;
import javax.annotation.Nonnull;

public class DexUtil {
    public static void verifyDexHeader(@Nonnull byte[] buf, int offset) {
        int dexVersion = HeaderItem.getVersion(buf, offset);
        if (dexVersion == -1) {
            StringBuilder sb = new StringBuilder("Not a valid dex magic value:");
            for (int i = 0; i < 8; ++i) {
                sb.append(String.format(" %02x", buf[i]));
            }
            throw new DexBackedDexFile.NotADexFile(sb.toString());
        }
        if (!HeaderItem.isSupportedDexVersion(dexVersion)) {
            throw new UnsupportedFile(String.format("Dex version %03d is not supported", dexVersion));
        }
        int endian = HeaderItem.getEndian(buf, offset);
        if (endian == 2018915346) {
            throw new UnsupportedFile("Big endian dex files are not supported");
        }
        if (endian != 305419896) {
            throw new InvalidFile(String.format("Invalid endian tag: 0x%x", endian));
        }
    }

    public static class UnsupportedFile
    extends RuntimeException {
        public UnsupportedFile() {
        }

        public UnsupportedFile(String message) {
            super(message);
        }
    }

    public static class InvalidFile
    extends RuntimeException {
        public InvalidFile() {
        }

        public InvalidFile(String message) {
            super(message);
        }
    }
}

