/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.SwitchElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ImmutableConverter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImmutableSwitchElement
implements SwitchElement {
    protected final int key;
    protected final int offset;
    private static final ImmutableConverter<ImmutableSwitchElement, SwitchElement> CONVERTER = new ImmutableConverter<ImmutableSwitchElement, SwitchElement>(){

        @Override
        protected boolean isImmutable(@Nonnull SwitchElement item) {
            return item instanceof ImmutableSwitchElement;
        }

        @Override
        @Nonnull
        protected ImmutableSwitchElement makeImmutable(@Nonnull SwitchElement item) {
            return ImmutableSwitchElement.of(item);
        }
    };

    public ImmutableSwitchElement(int key, int offset) {
        this.key = key;
        this.offset = offset;
    }

    @Nonnull
    public static ImmutableSwitchElement of(SwitchElement switchElement) {
        if (switchElement instanceof ImmutableSwitchElement) {
            return (ImmutableSwitchElement)switchElement;
        }
        return new ImmutableSwitchElement(switchElement.getKey(), switchElement.getOffset());
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Nonnull
    public static ImmutableList<ImmutableSwitchElement> immutableListOf(@Nullable List<? extends SwitchElement> list) {
        return CONVERTER.toList(list);
    }
}

