/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.DebugItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.EndLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.EpilogueBegin;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.LineNumber;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.PrologueEnd;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.RestartLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.SetSourceFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.StartLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableEndLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableEpilogueBegin;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableLineNumber;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutablePrologueEnd;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableRestartLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableSetSourceFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableStartLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ImmutableConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ImmutableDebugItem
implements DebugItem {
    protected final int codeAddress;
    private static final ImmutableConverter<ImmutableDebugItem, DebugItem> CONVERTER = new ImmutableConverter<ImmutableDebugItem, DebugItem>(){

        @Override
        protected boolean isImmutable(@Nonnull DebugItem item) {
            return item instanceof ImmutableDebugItem;
        }

        @Override
        @Nonnull
        protected ImmutableDebugItem makeImmutable(@Nonnull DebugItem item) {
            return ImmutableDebugItem.of(item);
        }
    };

    public ImmutableDebugItem(int codeAddress) {
        this.codeAddress = codeAddress;
    }

    @Nonnull
    public static ImmutableDebugItem of(DebugItem debugItem) {
        if (debugItem instanceof ImmutableDebugItem) {
            return (ImmutableDebugItem)debugItem;
        }
        switch (debugItem.getDebugItemType()) {
            case 3: {
                return ImmutableStartLocal.of((StartLocal)debugItem);
            }
            case 5: {
                return ImmutableEndLocal.of((EndLocal)debugItem);
            }
            case 6: {
                return ImmutableRestartLocal.of((RestartLocal)debugItem);
            }
            case 7: {
                return ImmutablePrologueEnd.of((PrologueEnd)debugItem);
            }
            case 8: {
                return ImmutableEpilogueBegin.of((EpilogueBegin)debugItem);
            }
            case 9: {
                return ImmutableSetSourceFile.of((SetSourceFile)debugItem);
            }
            case 10: {
                return ImmutableLineNumber.of((LineNumber)debugItem);
            }
        }
        throw new ExceptionWithContext("Invalid debug item type: %d", debugItem.getDebugItemType());
    }

    @Override
    public int getCodeAddress() {
        return this.codeAddress;
    }

    @Nonnull
    public static ImmutableList<ImmutableDebugItem> immutableListOf(@Nullable Iterable<? extends DebugItem> list) {
        return CONVERTER.toList(list);
    }
}

