/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Ordering;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseMethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Method;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.MethodImplementation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.MethodParameter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableMethodImplementation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableMethodParameter;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ImmutableConverter;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImmutableMethod
extends BaseMethodReference
implements Method {
    @Nonnull
    protected final String definingClass;
    @Nonnull
    protected final String name;
    @Nonnull
    protected final ImmutableList<? extends ImmutableMethodParameter> parameters;
    @Nonnull
    protected final String returnType;
    protected final int accessFlags;
    @Nonnull
    protected final ImmutableSet<? extends ImmutableAnnotation> annotations;
    @Nullable
    protected final ImmutableMethodImplementation methodImplementation;
    private static final ImmutableConverter<ImmutableMethod, Method> CONVERTER = new ImmutableConverter<ImmutableMethod, Method>(){

        @Override
        protected boolean isImmutable(@Nonnull Method item) {
            return item instanceof ImmutableMethod;
        }

        @Override
        @Nonnull
        protected ImmutableMethod makeImmutable(@Nonnull Method item) {
            return ImmutableMethod.of(item);
        }
    };

    public ImmutableMethod(@Nonnull String definingClass, @Nonnull String name, @Nullable Iterable<? extends MethodParameter> parameters, @Nonnull String returnType, int accessFlags, @Nullable Set<? extends Annotation> annotations, @Nullable MethodImplementation methodImplementation) {
        this.definingClass = definingClass;
        this.name = name;
        this.parameters = ImmutableMethodParameter.immutableListOf(parameters);
        this.returnType = returnType;
        this.accessFlags = accessFlags;
        this.annotations = ImmutableAnnotation.immutableSetOf(annotations);
        this.methodImplementation = ImmutableMethodImplementation.of(methodImplementation);
    }

    public static ImmutableMethod of(Method method) {
        if (method instanceof ImmutableMethod) {
            return (ImmutableMethod)method;
        }
        return new ImmutableMethod(method.getDefiningClass(), method.getName(), method.getParameters(), method.getReturnType(), method.getAccessFlags(), method.getAnnotations(), method.getImplementation());
    }

    @Override
    @Nonnull
    public String getDefiningClass() {
        return this.definingClass;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public ImmutableList<? extends CharSequence> getParameterTypes() {
        return this.parameters;
    }

    @Nonnull
    public ImmutableList<? extends ImmutableMethodParameter> getParameters() {
        return this.parameters;
    }

    @Override
    @Nonnull
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Nonnull
    public ImmutableSet<? extends ImmutableAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    @Nullable
    public ImmutableMethodImplementation getImplementation() {
        return this.methodImplementation;
    }

    @Nonnull
    public static ImmutableSortedSet<ImmutableMethod> immutableSetOf(@Nullable Iterable<? extends Method> list) {
        return CONVERTER.toSortedSet(Ordering.natural(), list);
    }
}

