/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.BaseExceptionHandler;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ExceptionHandler;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ImmutableConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImmutableExceptionHandler
extends BaseExceptionHandler
implements ExceptionHandler {
    @Nullable
    protected final String exceptionType;
    protected final int handlerCodeAddress;
    private static final ImmutableConverter<ImmutableExceptionHandler, ExceptionHandler> CONVERTER = new ImmutableConverter<ImmutableExceptionHandler, ExceptionHandler>(){

        @Override
        protected boolean isImmutable(@Nonnull ExceptionHandler item) {
            return item instanceof ImmutableExceptionHandler;
        }

        @Override
        @Nonnull
        protected ImmutableExceptionHandler makeImmutable(@Nonnull ExceptionHandler item) {
            return ImmutableExceptionHandler.of(item);
        }
    };

    public ImmutableExceptionHandler(@Nullable String exceptionType, int handlerCodeAddress) {
        this.exceptionType = exceptionType;
        this.handlerCodeAddress = handlerCodeAddress;
    }

    public static ImmutableExceptionHandler of(ExceptionHandler exceptionHandler) {
        if (exceptionHandler instanceof ImmutableExceptionHandler) {
            return (ImmutableExceptionHandler)exceptionHandler;
        }
        return new ImmutableExceptionHandler(exceptionHandler.getExceptionType(), exceptionHandler.getHandlerCodeAddress());
    }

    @Override
    @Nullable
    public String getExceptionType() {
        return this.exceptionType;
    }

    @Override
    public int getHandlerCodeAddress() {
        return this.handlerCodeAddress;
    }

    @Nonnull
    public static ImmutableList<ImmutableExceptionHandler> immutableListOf(@Nullable Iterable<? extends ExceptionHandler> list) {
        return CONVERTER.toList(list);
    }
}

