/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.value.DexBackedEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class StaticInitialValueIterator {
    public static final StaticInitialValueIterator EMPTY = new StaticInitialValueIterator(){

        @Override
        @Nullable
        public EncodedValue getNextOrNull() {
            return null;
        }

        @Override
        public int getReaderOffset() {
            return 0;
        }
    };

    @Nullable
    public abstract EncodedValue getNextOrNull();

    public abstract int getReaderOffset();

    @Nonnull
    public static StaticInitialValueIterator newOrEmpty(@Nonnull DexBackedDexFile dexFile, int offset) {
        if (offset == 0) {
            return EMPTY;
        }
        return new StaticInitialValueIteratorImpl(dexFile, offset);
    }

    private static class StaticInitialValueIteratorImpl
    extends StaticInitialValueIterator {
        @Nonnull
        private final DexReader reader;
        private final int size;
        private int index = 0;

        public StaticInitialValueIteratorImpl(@Nonnull DexBackedDexFile dexFile, int offset) {
            this.reader = dexFile.readerAt(offset);
            this.size = this.reader.readSmallUleb128();
        }

        @Override
        @Nullable
        public EncodedValue getNextOrNull() {
            if (this.index < this.size) {
                ++this.index;
                return DexBackedEncodedValue.readFrom(this.reader);
            }
            return null;
        }

        @Override
        public int getReaderOffset() {
            return this.reader.getOffset();
        }
    }
}

