/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseMethodProtoReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import java.util.List;
import javax.annotation.Nonnull;

public class DexBackedMethodProtoReference
extends BaseMethodProtoReference {
    @Nonnull
    public final DexBackedDexFile dexFile;
    private final int protoIdItemOffset;

    public DexBackedMethodProtoReference(@Nonnull DexBackedDexFile dexFile, int protoIndex) {
        this.dexFile = dexFile;
        this.protoIdItemOffset = dexFile.getProtoIdItemOffset(protoIndex);
    }

    @Nonnull
    public List<String> getParameterTypes() {
        int parametersOffset = this.dexFile.readSmallUint(this.protoIdItemOffset + 8);
        if (parametersOffset > 0) {
            final int parameterCount = this.dexFile.readSmallUint(parametersOffset + 0);
            final int paramListStart = parametersOffset + 4;
            return new FixedSizeList<String>(){

                @Override
                @Nonnull
                public String readItem(int index) {
                    return DexBackedMethodProtoReference.this.dexFile.getType(DexBackedMethodProtoReference.this.dexFile.readUshort(paramListStart + 2 * index));
                }

                @Override
                public int size() {
                    return parameterCount;
                }
            };
        }
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public String getReturnType() {
        return this.dexFile.getType(this.dexFile.readSmallUint(this.protoIdItemOffset + 4));
    }
}

