/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.SwitchElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import java.util.List;
import javax.annotation.Nonnull;

public class DexBackedPackedSwitchPayload
extends DexBackedInstruction
implements PackedSwitchPayload {
    public final int elementCount;

    public DexBackedPackedSwitchPayload(@Nonnull DexBackedDexFile dexFile, int instructionStart) {
        super(dexFile, Opcode.PACKED_SWITCH_PAYLOAD, instructionStart);
        this.elementCount = dexFile.readUshort(instructionStart + 2);
    }

    @Override
    @Nonnull
    public List<? extends SwitchElement> getSwitchElements() {
        final int firstKey = this.dexFile.readInt(this.instructionStart + 4);
        return new FixedSizeList<SwitchElement>(){

            @Override
            @Nonnull
            public SwitchElement readItem(final int index) {
                return new SwitchElement(){

                    @Override
                    public int getKey() {
                        return firstKey + index;
                    }

                    @Override
                    public int getOffset() {
                        return DexBackedPackedSwitchPayload.this.dexFile.readInt(DexBackedPackedSwitchPayload.this.instructionStart + 8 + index * 4);
                    }
                };
            }

            @Override
            public int size() {
                return DexBackedPackedSwitchPayload.this.elementCount;
            }
        };
    }

    @Override
    public int getCodeUnits() {
        return 4 + this.elementCount * 2;
    }
}

