/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseMethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.AnnotationsDirectory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.ParameterIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Method;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.MethodParameter;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.AbstractForwardSequentialList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DexBackedMethod
extends BaseMethodReference
implements Method {
    @Nonnull
    public final DexBackedDexFile dexFile;
    @Nonnull
    public final DexBackedClassDef classDef;
    public final int accessFlags;
    private final int codeOffset;
    private final int parameterAnnotationSetListOffset;
    private final int methodAnnotationSetOffset;
    public final int methodIndex;
    private final int startOffset;
    private int methodIdItemOffset;
    private int protoIdItemOffset;
    private int parametersOffset = -1;

    public DexBackedMethod(@Nonnull DexReader reader, @Nonnull DexBackedClassDef classDef, int previousMethodIndex, @Nonnull AnnotationsDirectory.AnnotationIterator methodAnnotationIterator, @Nonnull AnnotationsDirectory.AnnotationIterator paramaterAnnotationIterator) {
        this.dexFile = (DexBackedDexFile)reader.dexBuf;
        this.classDef = classDef;
        this.startOffset = reader.getOffset();
        int methodIndexDiff = reader.readLargeUleb128();
        this.methodIndex = methodIndexDiff + previousMethodIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.codeOffset = reader.readSmallUleb128();
        this.methodAnnotationSetOffset = methodAnnotationIterator.seekTo(this.methodIndex);
        this.parameterAnnotationSetListOffset = paramaterAnnotationIterator.seekTo(this.methodIndex);
    }

    @Override
    @Nonnull
    public String getDefiningClass() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.dexFile.getString(this.dexFile.readSmallUint(this.getMethodIdItemOffset() + 4));
    }

    @Override
    @Nonnull
    public String getReturnType() {
        return this.dexFile.getType(this.dexFile.readSmallUint(this.getProtoIdItemOffset() + 4));
    }

    @Override
    @Nonnull
    public List<? extends MethodParameter> getParameters() {
        int parametersOffset = this.getParametersOffset();
        if (parametersOffset > 0) {
            final List<String> parameterTypes = this.getParameterTypes();
            return new AbstractForwardSequentialList<MethodParameter>(){

                @Override
                @Nonnull
                public Iterator<MethodParameter> iterator() {
                    return new ParameterIterator(parameterTypes, DexBackedMethod.this.getParameterAnnotations(), DexBackedMethod.this.getParameterNames());
                }

                @Override
                public int size() {
                    return parameterTypes.size();
                }
            };
        }
        return ImmutableList.of();
    }

    @Nonnull
    public List<? extends Set<? extends DexBackedAnnotation>> getParameterAnnotations() {
        return AnnotationsDirectory.getParameterAnnotations(this.dexFile, this.parameterAnnotationSetListOffset);
    }

    @Nonnull
    public Iterator<String> getParameterNames() {
        DexBackedMethodImplementation methodImpl = this.getImplementation();
        if (methodImpl != null) {
            return methodImpl.getParameterNames(null);
        }
        return ImmutableSet.of().iterator();
    }

    @Nonnull
    public List<String> getParameterTypes() {
        int parametersOffset = this.getParametersOffset();
        if (parametersOffset > 0) {
            final int parameterCount = this.dexFile.readSmallUint(parametersOffset + 0);
            final int paramListStart = parametersOffset + 4;
            return new FixedSizeList<String>(){

                @Override
                @Nonnull
                public String readItem(int index) {
                    return DexBackedMethod.this.dexFile.getType(DexBackedMethod.this.dexFile.readUshort(paramListStart + 2 * index));
                }

                @Override
                public int size() {
                    return parameterCount;
                }
            };
        }
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public Set<? extends Annotation> getAnnotations() {
        return AnnotationsDirectory.getAnnotations(this.dexFile, this.methodAnnotationSetOffset);
    }

    @Override
    @Nullable
    public DexBackedMethodImplementation getImplementation() {
        if (this.codeOffset > 0) {
            return new DexBackedMethodImplementation(this.dexFile, this, this.codeOffset);
        }
        return null;
    }

    private int getMethodIdItemOffset() {
        if (this.methodIdItemOffset == 0) {
            this.methodIdItemOffset = this.dexFile.getMethodIdItemOffset(this.methodIndex);
        }
        return this.methodIdItemOffset;
    }

    private int getProtoIdItemOffset() {
        if (this.protoIdItemOffset == 0) {
            int protoIndex = this.dexFile.readUshort(this.getMethodIdItemOffset() + 2);
            this.protoIdItemOffset = this.dexFile.getProtoIdItemOffset(protoIndex);
        }
        return this.protoIdItemOffset;
    }

    private int getParametersOffset() {
        if (this.parametersOffset == -1) {
            this.parametersOffset = this.dexFile.readSmallUint(this.getProtoIdItemOffset() + 8);
        }
        return this.parametersOffset;
    }

    public static void skipMethods(@Nonnull DexReader reader, int count) {
        for (int i = 0; i < count; ++i) {
            reader.skipUleb128();
            reader.skipUleb128();
            reader.skipUleb128();
        }
    }
}

