/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseFieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.AnnotationsDirectory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.StaticInitialValueIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Field;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DexBackedField
extends BaseFieldReference
implements Field {
    @Nonnull
    public final DexBackedDexFile dexFile;
    @Nonnull
    public final ClassDef classDef;
    public final int accessFlags;
    @Nullable
    public final EncodedValue initialValue;
    public final int annotationSetOffset;
    public final int fieldIndex;
    private final int startOffset;
    private final int initialValueOffset;
    private int fieldIdItemOffset;

    public DexBackedField(@Nonnull DexReader reader, @Nonnull DexBackedClassDef classDef, int previousFieldIndex, @Nonnull StaticInitialValueIterator staticInitialValueIterator, @Nonnull AnnotationsDirectory.AnnotationIterator annotationIterator) {
        this.dexFile = (DexBackedDexFile)reader.dexBuf;
        this.classDef = classDef;
        this.startOffset = reader.getOffset();
        int fieldIndexDiff = reader.readLargeUleb128();
        this.fieldIndex = fieldIndexDiff + previousFieldIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValueOffset = staticInitialValueIterator.getReaderOffset();
        this.initialValue = staticInitialValueIterator.getNextOrNull();
    }

    public DexBackedField(@Nonnull DexReader reader, @Nonnull DexBackedClassDef classDef, int previousFieldIndex, @Nonnull AnnotationsDirectory.AnnotationIterator annotationIterator) {
        this.dexFile = (DexBackedDexFile)reader.dexBuf;
        this.classDef = classDef;
        this.startOffset = reader.getOffset();
        int fieldIndexDiff = reader.readLargeUleb128();
        this.fieldIndex = fieldIndexDiff + previousFieldIndex;
        this.accessFlags = reader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValueOffset = 0;
        this.initialValue = null;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.dexFile.getString(this.dexFile.readSmallUint(this.getFieldIdItemOffset() + 4));
    }

    @Override
    @Nonnull
    public String getType() {
        return this.dexFile.getType(this.dexFile.readUshort(this.getFieldIdItemOffset() + 2));
    }

    @Override
    @Nonnull
    public String getDefiningClass() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    @Nullable
    public EncodedValue getInitialValue() {
        return this.initialValue;
    }

    @Nonnull
    public Set<? extends DexBackedAnnotation> getAnnotations() {
        return AnnotationsDirectory.getAnnotations(this.dexFile, this.annotationSetOffset);
    }

    public static void skipFields(@Nonnull DexReader reader, int count) {
        for (int i = 0; i < count; ++i) {
            reader.skipUleb128();
            reader.skipUleb128();
        }
    }

    private int getFieldIdItemOffset() {
        if (this.fieldIdItemOffset == 0) {
            this.fieldIdItemOffset = this.dexFile.getFieldIdItemOffset(this.fieldIndex);
        }
        return this.fieldIdItemOffset;
    }
}

