/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.BaseDexBuffer;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeSet;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.DexUtil;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DexBackedDexFile
extends BaseDexBuffer
implements DexFile {
    @Nonnull
    private final Opcodes opcodes;
    private final int stringCount;
    private final int stringStartOffset;
    private final int typeCount;
    private final int typeStartOffset;
    private final int protoCount;
    private final int protoStartOffset;
    private final int fieldCount;
    private final int fieldStartOffset;
    private final int methodCount;
    private final int methodStartOffset;
    private final int classCount;
    private final int classStartOffset;

    protected DexBackedDexFile(@Nonnull Opcodes opcodes, @Nonnull byte[] buf, int offset, boolean verifyMagic) {
        super(buf, offset);
        this.opcodes = opcodes;
        if (verifyMagic) {
            DexUtil.verifyDexHeader(buf, offset);
        }
        this.stringCount = this.readSmallUint(56);
        this.stringStartOffset = this.readSmallUint(60);
        this.typeCount = this.readSmallUint(64);
        this.typeStartOffset = this.readSmallUint(68);
        this.protoCount = this.readSmallUint(72);
        this.protoStartOffset = this.readSmallUint(76);
        this.fieldCount = this.readSmallUint(80);
        this.fieldStartOffset = this.readSmallUint(84);
        this.methodCount = this.readSmallUint(88);
        this.methodStartOffset = this.readSmallUint(92);
        this.classCount = this.readSmallUint(96);
        this.classStartOffset = this.readSmallUint(100);
    }

    public DexBackedDexFile(@Nonnull Opcodes opcodes, @Nonnull byte[] buf) {
        this(opcodes, buf, 0, true);
    }

    @Override
    @Nonnull
    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    @Nonnull
    public Set<? extends DexBackedClassDef> getClasses() {
        return new FixedSizeSet<DexBackedClassDef>(){

            @Override
            @Nonnull
            public DexBackedClassDef readItem(int index) {
                return new DexBackedClassDef(DexBackedDexFile.this, DexBackedDexFile.this.getClassDefItemOffset(index));
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.classCount;
            }
        };
    }

    public int getStringIdItemOffset(int stringIndex) {
        if (stringIndex < 0 || stringIndex >= this.stringCount) {
            throw new InvalidItemIndex(stringIndex, "String index out of bounds: %d", stringIndex);
        }
        return this.stringStartOffset + stringIndex * 4;
    }

    public int getTypeIdItemOffset(int typeIndex) {
        if (typeIndex < 0 || typeIndex >= this.typeCount) {
            throw new InvalidItemIndex(typeIndex, "Type index out of bounds: %d", typeIndex);
        }
        return this.typeStartOffset + typeIndex * 4;
    }

    public int getFieldIdItemOffset(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.fieldCount) {
            throw new InvalidItemIndex(fieldIndex, "Field index out of bounds: %d", fieldIndex);
        }
        return this.fieldStartOffset + fieldIndex * 8;
    }

    public int getMethodIdItemOffset(int methodIndex) {
        if (methodIndex < 0 || methodIndex >= this.methodCount) {
            throw new InvalidItemIndex(methodIndex, "Method index out of bounds: %d", methodIndex);
        }
        return this.methodStartOffset + methodIndex * 8;
    }

    public int getProtoIdItemOffset(int protoIndex) {
        if (protoIndex < 0 || protoIndex >= this.protoCount) {
            throw new InvalidItemIndex(protoIndex, "Proto index out of bounds: %d", protoIndex);
        }
        return this.protoStartOffset + protoIndex * 12;
    }

    public int getClassDefItemOffset(int classIndex) {
        if (classIndex < 0 || classIndex >= this.classCount) {
            throw new InvalidItemIndex(classIndex, "Class index out of bounds: %d", classIndex);
        }
        return this.classStartOffset + classIndex * 32;
    }

    @Nonnull
    public String getString(int stringIndex) {
        int stringOffset = this.getStringIdItemOffset(stringIndex);
        int stringDataOffset = this.readSmallUint(stringOffset);
        DexReader reader = this.readerAt(stringDataOffset);
        int utf16Length = reader.readSmallUleb128();
        return reader.readString(utf16Length);
    }

    @Nullable
    public String getOptionalString(int stringIndex) {
        if (stringIndex == -1) {
            return null;
        }
        return this.getString(stringIndex);
    }

    @Nonnull
    public String getType(int typeIndex) {
        int typeOffset = this.getTypeIdItemOffset(typeIndex);
        int stringIndex = this.readSmallUint(typeOffset);
        return this.getString(stringIndex);
    }

    @Nullable
    public String getOptionalType(int typeIndex) {
        if (typeIndex == -1) {
            return null;
        }
        return this.getType(typeIndex);
    }

    @Nonnull
    public DexReader readerAt(int offset) {
        return new DexReader(this, offset);
    }

    public static class InvalidItemIndex
    extends ExceptionWithContext {
        private final int itemIndex;

        public InvalidItemIndex(int itemIndex, String message, Object ... formatArgs) {
            super(message, formatArgs);
            this.itemIndex = itemIndex;
        }
    }

    public static class NotADexFile
    extends RuntimeException {
        public NotADexFile() {
        }

        public NotADexFile(String message) {
            super(message);
        }
    }
}

