/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.BaseAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedAnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.VariableSizeSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class DexBackedAnnotation
extends BaseAnnotation {
    @Nonnull
    public final DexBackedDexFile dexFile;
    public final int visibility;
    public final int typeIndex;
    private final int elementsOffset;

    public DexBackedAnnotation(@Nonnull DexBackedDexFile dexFile, int annotationOffset) {
        this.dexFile = dexFile;
        DexReader reader = dexFile.readerAt(annotationOffset);
        this.visibility = reader.readUbyte();
        this.typeIndex = reader.readSmallUleb128();
        this.elementsOffset = reader.getOffset();
    }

    @Override
    public int getVisibility() {
        return this.visibility;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.dexFile.getType(this.typeIndex);
    }

    @Nonnull
    public Set<? extends DexBackedAnnotationElement> getElements() {
        DexReader reader = this.dexFile.readerAt(this.elementsOffset);
        int size = reader.readSmallUleb128();
        return new VariableSizeSet<DexBackedAnnotationElement>(this.dexFile, reader.getOffset(), size){

            @Override
            @Nonnull
            protected DexBackedAnnotationElement readNextItem(@Nonnull DexReader reader, int index) {
                return new DexBackedAnnotationElement(reader);
            }
        };
    }
}

