/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;
import javax.annotation.Nonnull;

public class BuilderInstruction22s
extends BuilderInstruction
implements Instruction22s {
    public static final Format FORMAT = Format.Format22s;
    protected final int registerA;
    protected final int registerB;
    protected final int literal;

    public BuilderInstruction22s(@Nonnull Opcode opcode, int registerA, int registerB, int literal) {
        super(opcode);
        this.registerA = Preconditions.checkNibbleRegister(registerA);
        this.registerB = Preconditions.checkNibbleRegister(registerB);
        this.literal = Preconditions.checkShortLiteral(literal);
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    @Override
    public int getNarrowLiteral() {
        return this.literal;
    }

    @Override
    public long getWideLiteral() {
        return this.literal;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

