/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.Label;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.OffsetInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import javax.annotation.Nonnull;

public abstract class BuilderOffsetInstruction
extends BuilderInstruction
implements OffsetInstruction {
    @Nonnull
    protected final Label target;

    public BuilderOffsetInstruction(@Nonnull Opcode opcode, @Nonnull Label target) {
        super(opcode);
        this.target = target;
    }

    @Override
    public int getCodeOffset() {
        int codeOffset = this.internalGetCodeOffset();
        if (this.getCodeUnits() == 1) {
            if (codeOffset < -128 || codeOffset > 127) {
                throw new ExceptionWithContext("Invalid instruction offset: %d. Offset must be in [-128, 127]", codeOffset);
            }
        } else if (this.getCodeUnits() == 2 && (codeOffset < Short.MIN_VALUE || codeOffset > Short.MAX_VALUE)) {
            throw new ExceptionWithContext("Invalid instruction offset: %d. Offset must be in [-32768, 32767]", codeOffset);
        }
        return codeOffset;
    }

    int internalGetCodeOffset() {
        return this.target.getCodeAddress() - this.getLocation().getCodeAddress();
    }

    @Nonnull
    public Label getTarget() {
        return this.target;
    }
}

