/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexFiles;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.TypeUtils;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.AnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Method;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.IntEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableAnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableMethod;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableIntEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DexDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.FileDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.DexPool;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DexFilesImpl
implements DexFiles {
    private final Map<String, DexFile> dexFileMap;
    private final Set<ImmutableDexFile> dexFiles;
    private final File cacheDir;
    private final DexFileLoader dexFileLoader;

    DexFilesImpl(Map<String, DexFile> dexFileMap, Set<ImmutableDexFile> dexFiles, File cacheDir, DexFileLoader dexFileLoader) {
        this.dexFileMap = dexFileMap;
        this.dexFiles = dexFiles;
        this.cacheDir = cacheDir;
        this.dexFileLoader = dexFileLoader;
    }

    @Override
    public DexFile get(String className) throws IOException {
        DexFile cached = this.getFromCache(className);
        if (cached != null) {
            return cached;
        }
        ImmutableDexFile file = this.getDexFileToBeOpened(className);
        if (file == null) {
            return null;
        }
        if (this.cacheDir.isDirectory() || this.cacheDir.mkdirs()) {
            return this.putToCache(this.generate(DexFilesImpl.open(file)));
        }
        throw new IllegalStateException("Cannot create " + this.cacheDir);
    }

    private DexFile getFromCache(String className) {
        DexFile dexFile = this.dexFileMap.get(className);
        if (dexFile == null) {
            return null;
        }
        Logger logger = Loggers.get();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("The DEX file for " + className + " was found in the cache");
        }
        return dexFile;
    }

    private ImmutableDexFile getDexFileToBeOpened(String className) {
        Iterator<ImmutableDexFile> it = this.dexFiles.iterator();
        while (it.hasNext()) {
            ImmutableDexFile dexFile = it.next();
            for (ClassDef def : dexFile.getClasses()) {
                if (!def.getType().equals(TypeUtils.getInternalName(className))) continue;
                it.remove();
                return dexFile;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexFile generate(DexPool pool) throws IOException {
        DexFile dexFile;
        File dex = File.createTempFile("classes", ".dex", this.cacheDir);
        try {
            pool.writeTo((DexDataStore)new FileDataStore(dex));
            String sourcePathName = dex.getCanonicalPath();
            String outputPathName = sourcePathName + ".opt";
            DexFile dexFile2 = this.dexFileLoader.loadDex(sourcePathName, outputPathName, 0);
            Logger logger = Loggers.get();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("An optimized DEX file generated: " + outputPathName);
            }
            dexFile = dexFile2;
        }
        catch (Throwable throwable) {
            FileUtils.delete(dex);
            throw throwable;
        }
        FileUtils.delete(dex);
        return dexFile;
    }

    private DexFile putToCache(DexFile dexFile) {
        Enumeration e = dexFile.entries();
        while (e.hasMoreElements()) {
            this.dexFileMap.put((String)e.nextElement(), dexFile);
        }
        return dexFile;
    }

    private static DexPool open(ImmutableDexFile dexFile) {
        DexPool pool = new DexPool(dexFile.getOpcodes());
        for (ClassDef def : dexFile.getClasses()) {
            String type = def.getType();
            pool.internClass((ClassDef)new ImmutableClassDef(type, DexFilesImpl.open(def.getAccessFlags()), def.getSuperclass(), (Collection)def.getInterfaces(), def.getSourceFile(), DexFilesImpl.open(def.getAnnotations()), def.getFields(), DexFilesImpl.open(def.getMethods())));
            Logger logger = Loggers.get();
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest("Class to be opened: " + TypeUtils.getClassName(type));
        }
        return pool;
    }

    private static int open(int accessFlags) {
        return accessFlags & 0xFFFFFFEF;
    }

    private static Set<Annotation> open(Set<? extends Annotation> annotations) {
        HashSet<Annotation> set = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            String type = annotation.getType();
            if (type.equals("Ldalvik/annotation/InnerClass;")) {
                HashSet<Object> elements = new HashSet<Object>();
                for (AnnotationElement e : annotation.getElements()) {
                    String name = e.getName();
                    if (name.equals("accessFlags")) {
                        int accessFlags = DexFilesImpl.open(((IntEncodedValue)e.getValue()).getValue());
                        ImmutableIntEncodedValue value = new ImmutableIntEncodedValue(accessFlags);
                        elements.add(new ImmutableAnnotationElement(name, (EncodedValue)value));
                        continue;
                    }
                    elements.add(e);
                }
                set.add((Annotation)new ImmutableAnnotation(annotation.getVisibility(), type, elements));
                continue;
            }
            set.add(annotation);
        }
        return set;
    }

    private static Set<Method> open(Iterable<? extends Method> methods) {
        HashSet<Method> set = new HashSet<Method>();
        for (Method method : methods) {
            set.add((Method)new ImmutableMethod(method.getDefiningClass(), method.getName(), (Iterable)method.getParameters(), method.getReturnType(), DexFilesImpl.open(method.getAccessFlags()), method.getAnnotations(), method.getImplementation()));
        }
        return set;
    }
}

