/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IOffsetInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IPseudoInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureCommon.Label;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class PseudoInstructionPackedSwitch
extends Instruction
implements IPseudoInstruction {
    private static final int PACKED_SWITCH_OPCODE = 256;
    private int firstKey;
    private Label[] targets;
    private IOffsetInstruction instructionPackedSwitch;

    @Override
    public IOffsetInstruction getSourceInstruction() {
        return this.instructionPackedSwitch;
    }

    public PseudoInstructionPackedSwitch(int firstKey, Label[] targets, IOffsetInstruction instructionPackedSwitch) {
        super(256);
        this.firstKey = firstKey;
        this.targets = targets;
        this.instructionPackedSwitch = instructionPackedSwitch;
    }

    @Override
    public int getSize() {
        return this.targets.length * 4 + 2 + 2 + 4;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        out.putShort(256);
        int size = this.targets.length;
        out.putShort(size);
        out.putInt(this.firstKey);
        for (int i = 0; i < size; ++i) {
            out.putInt((this.targets[i].getOffset() - this.instructionPackedSwitch.getInstructionOffset()) / 2);
        }
    }
}

