/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexFiles;
import com.github.tmurakami.dexopener.TypeUtils;
import dalvik.system.DexFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class DexFilesFactory {
    private static final int MAX_SIZE_PER_NAMES = 150;
    private final File cacheDir;
    private final DexFileLoader dexFileLoader;

    DexFilesFactory(File cacheDir, DexFileLoader dexFileLoader) {
        this.cacheDir = cacheDir;
        this.dexFileLoader = dexFileLoader;
    }

    DexFiles newDexFiles(byte[] byteCode, Set<String> classNames) {
        return new DexFiles(byteCode, DexFilesFactory.toInternalNamesSet(classNames), this.cacheDir, this.dexFileLoader, new HashMap<String, DexFile>());
    }

    private static Set<Set<String>> toInternalNamesSet(Set<String> classNames) {
        ArrayList<String> list = new ArrayList<String>(classNames);
        Collections.sort(list);
        HashSet<Set<String>> internalNamesSet = new HashSet<Set<String>>();
        HashSet<String> internalNames = new HashSet<String>();
        for (String name : list) {
            internalNames.add(TypeUtils.getInternalName(name));
            if (internalNames.size() != 150) continue;
            internalNamesSet.add(Collections.unmodifiableSet(internalNames));
            internalNames = new HashSet();
        }
        if (!internalNames.isEmpty()) {
            internalNamesSet.add(Collections.unmodifiableSet(internalNames));
        }
        return internalNamesSet;
    }
}

