/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexUtils;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ClassVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class InternalNamesSetReader
extends ApplicationVisitor {
    private static final int MAX_SIZE_PER_LIST = 150;
    private final Set<String> internalNames = new HashSet<String>();
    private final ClassNameFilter classNameFilter;

    InternalNamesSetReader(ClassNameFilter classNameFilter) {
        super(262144);
        this.classNameFilter = classNameFilter;
    }

    public ClassVisitor visitClass(int access, String name, String[] signature, String superName, String[] interfaces) {
        if (this.classNameFilter.accept(DexUtils.toClassName(name))) {
            this.internalNames.add(name);
        }
        return null;
    }

    Set<Set<String>> read(ApplicationReader applicationReader) {
        applicationReader.accept((ApplicationVisitor)this, null, 3);
        ArrayList<String> list = new ArrayList<String>(this.internalNames);
        this.internalNames.clear();
        Collections.sort(list);
        HashSet set = new HashSet();
        HashSet<String> names = new HashSet<String>();
        for (String n : list) {
            names.add(n);
            if (names.size() != 150) continue;
            set.add(Collections.unmodifiableSet(names));
            names = new HashSet();
        }
        if (!names.isEmpty()) {
            set.add(Collections.unmodifiableSet(names));
        }
        return Collections.unmodifiableSet(set);
    }
}

