/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.content.pm.ApplicationInfo;
import android.support.annotation.NonNull;
import com.github.tmurakami.classinjector.ClassInjector;
import com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.AndroidClassSource;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexClassFileFactory;
import com.github.tmurakami.dexopener.DexClassSourceFactory;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexOpener;
import com.github.tmurakami.dexopener.FileUtils;
import java.io.File;

final class DexOpenerImpl
extends DexOpener {
    private final ApplicationInfo applicationInfo;
    private final ClassNameFilter classNameFilter;
    private final DexFileLoader dexFileLoader;
    private final DexClassFileFactory dexClassFileFactory;

    DexOpenerImpl(ApplicationInfo applicationInfo, ClassNameFilter classNameFilter, DexFileLoader dexFileLoader, DexClassFileFactory dexClassFileFactory) {
        this.applicationInfo = applicationInfo;
        this.classNameFilter = classNameFilter;
        this.dexFileLoader = dexFileLoader;
        this.dexClassFileFactory = dexClassFileFactory;
    }

    @Override
    public void installTo(@NonNull ClassLoader classLoader) {
        ApplicationInfo ai = this.applicationInfo;
        File cacheDir = new File(ai.dataDir, "code_cache/dexopener");
        if (cacheDir.isDirectory()) {
            FileUtils.delete(cacheDir.listFiles());
        }
        ClassInjector.from((ClassSource)new AndroidClassSource(ai.sourceDir, this.classNameFilter, new DexClassSourceFactory(cacheDir, this.dexFileLoader, this.dexClassFileFactory))).into(classLoader);
    }
}

