/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.support.annotation.NonNull;
import com.github.tmurakami.classinjector.ClassFile;
import com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.ApplicationOpener;
import com.github.tmurakami.dexopener.DexClassFileFactory;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexUtils;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationWriter;
import dalvik.system.DexFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

final class DexClassSource
implements ClassSource {
    private byte[] byteCode;
    private final Set<Set<String>> internalNamesSet;
    private final Map<String, DexFile> dexFileMap = new HashMap<String, DexFile>();
    private final File cacheDir;
    private final DexFileLoader dexFileLoader;
    private final DexClassFileFactory classFileFactory;

    DexClassSource(byte[] byteCode, Set<Set<String>> internalNamesSet, File cacheDir, DexFileLoader dexFileLoader, DexClassFileFactory classFileFactory) {
        this.byteCode = byteCode;
        this.internalNamesSet = new HashSet<Set<String>>(internalNamesSet);
        this.cacheDir = cacheDir;
        this.dexFileLoader = dexFileLoader;
        this.classFileFactory = classFileFactory;
    }

    public ClassFile getClassFile(@NonNull String className) throws IOException {
        DexFile dexFile = this.getDexFile(className);
        return dexFile == null ? null : this.classFileFactory.newClassFile(className, dexFile);
    }

    private DexFile getDexFile(String className) throws IOException {
        byte[] openedByteCode;
        String internalName = DexUtils.toInternalName(className);
        DexFile dexFile = this.dexFileMap.get(internalName);
        if (dexFile != null) {
            return dexFile;
        }
        byte[] byteCode = this.byteCode;
        if (byteCode == null) {
            return null;
        }
        String[] classesToVisit = DexClassSource.getClassesToVisit(internalName, this.internalNamesSet);
        if (classesToVisit == null) {
            return null;
        }
        if (this.internalNamesSet.isEmpty()) {
            this.byteCode = null;
        }
        try {
            openedByteCode = DexClassSource.openClasses(byteCode, classesToVisit);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while processing the class '" + className + "'", e);
        }
        if (!this.cacheDir.isDirectory() && !this.cacheDir.mkdirs()) {
            throw new IllegalStateException("Cannot create " + this.cacheDir);
        }
        dexFile = DexClassSource.loadDex(this.dexFileLoader, this.cacheDir, openedByteCode);
        for (String n : classesToVisit) {
            this.dexFileMap.put(n, dexFile);
        }
        return dexFile;
    }

    private static String[] getClassesToVisit(String internalName, Set<Set<String>> internalNamesSet) {
        Iterator<Set<String>> it = internalNamesSet.iterator();
        while (it.hasNext()) {
            Set<String> set = it.next();
            if (!set.contains(internalName)) continue;
            it.remove();
            return set.toArray(new String[set.size()]);
        }
        return null;
    }

    private static byte[] openClasses(byte[] byteCode, String[] classesToVisit) {
        ApplicationWriter aw = new ApplicationWriter();
        new ApplicationReader(262144, byteCode).accept((ApplicationVisitor)new ApplicationOpener((ApplicationVisitor)aw), classesToVisit, 0);
        return aw.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DexFile loadDex(DexFileLoader dexFileLoader, File cacheDir, byte[] byteCode) throws IOException {
        DexFile dexFile;
        File zip = File.createTempFile("classes", ".zip", cacheDir);
        try {
            try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip));){
                out.putNextEntry(new ZipEntry("classes.dex"));
                out.write(byteCode);
            }
            String sourcePathName = zip.getCanonicalPath();
            dexFile = dexFileLoader.loadDex(sourcePathName, sourcePathName + ".dex", 0);
        }
        catch (Throwable throwable) {
            FileUtils.delete(zip);
            throw throwable;
        }
        FileUtils.delete(zip);
        return dexFile;
    }
}

