/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.support.annotation.NonNull;
import com.github.tmurakami.classinjector.ClassFile;
import com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.classinjector.ClassSources;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexClassSourceFactory;
import com.github.tmurakami.dexopener.IOUtils;
import com.github.tmurakami.dexopener.InternalNamesSetReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class AndroidClassSource
implements ClassSource {
    private final String sourceDir;
    private final ClassNameFilter classNameFilter;
    private final DexClassSourceFactory dexClassSourceFactory;
    private ClassSource delegate;

    AndroidClassSource(String sourceDir, ClassNameFilter classNameFilter, DexClassSourceFactory dexClassSourceFactory) {
        this.sourceDir = sourceDir;
        this.classNameFilter = classNameFilter;
        this.dexClassSourceFactory = dexClassSourceFactory;
    }

    public ClassFile getClassFile(@NonNull String className) throws IOException {
        return this.classNameFilter.accept(className) ? this.getDelegate().getClassFile(className) : null;
    }

    private ClassSource getDelegate() throws IOException {
        ClassSource source = this.delegate;
        if (source == null) {
            source = this.delegate = this.newDelegate();
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassSource newDelegate() throws IOException {
        ArrayList<ClassSource> sources = new ArrayList<ClassSource>();
        InternalNamesSetReader r = new InternalNamesSetReader(this.classNameFilter);
        try (ZipInputStream in = new ZipInputStream(new FileInputStream(this.sourceDir));){
            ZipEntry e;
            while ((e = in.getNextEntry()) != null) {
                byte[] byteCode;
                ApplicationReader ar;
                Set<Set<String>> set;
                String name = e.getName();
                if (!name.startsWith("classes") || !name.endsWith(".dex") || (set = r.read(ar = new ApplicationReader(262144, byteCode = IOUtils.readBytes(in)))).isEmpty()) continue;
                sources.add(this.dexClassSourceFactory.newClassSource(byteCode, set));
            }
        }
        return new ClassSources(sources);
    }
}

