/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.ILongLiteralInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IOneRegisterInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat51L
extends Instruction
implements IOneRegisterInstruction,
ILongLiteralInstruction {
    private static final int INSTRUCTION_SIZE = 10;
    private int registerA;
    private long literalB;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public long getLiteral() {
        return this.literalB;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xFF;
    }

    public static long getLiteralB(IDalvikValueReader reader) {
        return (long)reader.sbyte() & 0xFFL | ((long)reader.sbyte() & 0xFFL) << 8 | ((long)reader.sbyte() & 0xFFL) << 16 | ((long)reader.sbyte() & 0xFFL) << 24 | ((long)reader.sbyte() & 0xFFL) << 32 | ((long)reader.sbyte() & 0xFFL) << 40 | ((long)reader.sbyte() & 0xFFL) << 48 | ((long)reader.sbyte() & 0xFFL) << 56;
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(8);
    }

    public InstructionFormat51L(int opcode, int destinationRegister, long var) {
        super(opcode);
        this.registerA = destinationRegister;
        this.literalB = var;
    }

    @Override
    public int getSize() {
        return 10;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        InstructionFormat51L.test8BitsLimit(this.registerA);
        out.putShort(((this.registerA & 0xFF) << 8) + this.opcodeByte);
        out.putByte((byte)this.literalB);
        out.putByte((byte)(this.literalB >> 8));
        out.putByte((byte)(this.literalB >> 16));
        out.putByte((byte)(this.literalB >> 24));
        out.putByte((byte)(this.literalB >> 32));
        out.putByte((byte)(this.literalB >> 40));
        out.putByte((byte)(this.literalB >> 48));
        out.putByte((byte)(this.literalB >> 56));
    }
}

