/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Instrumentation;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.BuiltinClassNameFilter;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.ClassNameFilters;
import com.github.tmurakami.dexopener.DexClassFileFactory;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexOpenerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class DexOpener {
    DexOpener() {
    }

    public static void install(@NonNull Instrumentation instrumentation) {
        Context context = instrumentation.getTargetContext();
        if (context == null) {
            throw new IllegalArgumentException("'instrumentation' has not been initialized yet");
        }
        DexOpener.builder(context).build().install(context.getClassLoader());
    }

    public abstract void install(@NonNull ClassLoader var1);

    @NonNull
    public static Builder builder(@NonNull Context context) {
        return new Builder(context.getApplicationInfo()).classNameFilters(BuiltinClassNameFilter.INSTANCE);
    }

    public static final class Builder {
        private final List<ClassNameFilter> classNameFilters = new ArrayList<ClassNameFilter>();
        private final ApplicationInfo applicationInfo;

        Builder(ApplicationInfo applicationInfo) {
            this.applicationInfo = applicationInfo;
        }

        @NonNull
        public Builder classNameFilters(ClassNameFilter ... filters) {
            for (ClassNameFilter f : filters) {
                if (f == null) {
                    throw new IllegalArgumentException("'filters' contains null");
                }
                this.classNameFilters.add(f);
            }
            return this;
        }

        @NonNull
        public DexOpener build() {
            ArrayList<ClassNameFilter> filters = new ArrayList<ClassNameFilter>(this.classNameFilters);
            ClassNameFilters filter = new ClassNameFilters(Collections.unmodifiableList(filters));
            return new DexOpenerImpl(this.applicationInfo, filter, DexFileLoader.INSTANCE, DexClassFileFactory.INSTANCE);
        }
    }
}

