/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueUtil;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class EncodedValueType
extends EncodedValue {
    private int type = 24;
    private String value;

    public EncodedValueType(String value) {
        this.value = value;
    }

    public EncodedValueType(Object value) {
        this.value = (String)value;
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        int index = constantPool.getTypeIndex(this.value);
        return EncodedValueUtil.encodeUnsignedValue(index, this.type);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueType) {
            EncodedValueType encodedValue = (EncodedValueType)o;
            result = this.type == encodedValue.type && this.value.equals(encodedValue.value);
        }
        return result;
    }

    public int hashCode() {
        return this.type + this.value.hashCode();
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        if (this == encodedValue) {
            return 0;
        }
        EncodedValueType et = (EncodedValueType)encodedValue;
        return this.value.compareTo(et.value);
    }
}

