/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public abstract class Instruction {
    protected int opcodeHighOrderByte;
    protected int opcodeByte;
    protected int lineNumber;
    private static final byte[] instructionSizeInBytes = new byte[]{2, 2, 4, 6, 2, 4, 6, 2, 4, 6, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 6, 4, 4, 6, 10, 4, 4, 6, 4, 2, 2, 4, 4, 2, 4, 4, 6, 6, 6, 2, 2, 4, 6, 6, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 6, 6, 6, 2, 6, 6, 6, 6, 6, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};

    public Instruction(int opcode) {
        this.opcodeHighOrderByte = opcode >> 8 & 0xFF;
        this.opcodeByte = opcode & 0xFF;
    }

    public abstract void write(ByteVector var1, ConstantPool var2);

    public abstract int getSize();

    public int getOpcodeHighOrderByte() {
        return this.opcodeHighOrderByte;
    }

    public int getOpcodeByte() {
        return this.opcodeByte;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public static void test4BitsLimit(int number) {
        if (number > 15) {
            throw new IllegalArgumentException("The number " + number + " can't be held in 4 bits !");
        }
    }

    public static void test8BitsLimit(int number) {
        if ((number & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("The number " + number + " can't be held in 8 bits !");
        }
    }

    public static void test16BitsLimit(int number) {
        if ((number & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("The number " + number + " can't be held in 16 bits !");
        }
    }

    public static void test4BitsLimit(int[] numbers) {
        for (int number : numbers) {
            Instruction.test4BitsLimit(number);
        }
    }

    public static void testRange(int[] numbers) {
        int length = numbers.length;
        if (length == 0) {
            throw new IllegalArgumentException("Too short for a range");
        }
        int expected = numbers[0];
        for (int i = 1; i < length; ++i) {
            if (numbers[i] == ++expected) continue;
            throw new IllegalArgumentException("The register at position " + i + " is not consecutive.");
        }
    }

    public static byte getInstructionSizeInByte(int opcode) {
        return instructionSizeInBytes[opcode];
    }
}

