/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue;

public class EncodedValueUtil {
    public static byte encodeHeader(int size, int type) {
        if (type == 0 || type >= 28) {
            return (byte)type;
        }
        return (byte)(type | size - 1 << 5);
    }

    public static byte[] encodeUnsignedValue(int val, int type) {
        int nb1 = 0;
        int nb2 = 0;
        int nb3 = 0;
        int nb4 = 0;
        int size = 1;
        if (val != 0) {
            nb1 = val & 0xFF;
            if ((val >>>= 8) != 0) {
                ++size;
                nb2 = val & 0xFF;
                if ((val >>>= 8) != 0) {
                    ++size;
                    nb3 = val & 0xFF;
                    if ((val >>>= 8) != 0) {
                        ++size;
                        nb4 = val & 0xFF;
                    }
                }
            }
        }
        byte[] result = new byte[size + 1];
        if (size > 3) {
            result[4] = (byte)nb4;
        }
        if (size > 2) {
            result[3] = (byte)nb3;
        }
        if (size > 1) {
            result[2] = (byte)nb2;
        }
        result[1] = (byte)nb1;
        result[0] = EncodedValueUtil.encodeHeader(size, type);
        return result;
    }

    public static byte[] encodeSignedValue(int val, int type) {
        int nbBytes = EncodedValueUtil.getNbBytesInSignedValue(val);
        byte[] bytes = new byte[nbBytes + 1];
        for (int i = 1; i < nbBytes + 1; ++i) {
            bytes[i] = (byte)val;
            val >>= 8;
        }
        bytes[0] = EncodedValueUtil.encodeHeader(nbBytes, type);
        return bytes;
    }

    public static byte[] encodeSignedValue(long val, int type) {
        int nbBytes = EncodedValueUtil.getNbBytesInSignedValue(val);
        byte[] bytes = new byte[nbBytes + 1];
        for (int i = 1; i < nbBytes + 1; ++i) {
            bytes[i] = (byte)val;
            val >>= 8;
        }
        bytes[0] = EncodedValueUtil.encodeHeader(nbBytes, type);
        return bytes;
    }

    public static byte[] encodeZeroExtendedToRightValue(long val, int type) {
        int nbBytes = EncodedValueUtil.getNbBytesForRightZeroExtendedValue(val);
        val >>= 64 - nbBytes * 8;
        byte[] bytes = new byte[nbBytes + 1];
        for (int i = 1; i < nbBytes + 1; ++i) {
            bytes[i] = (byte)val;
            val >>= 8;
        }
        bytes[0] = EncodedValueUtil.encodeHeader(nbBytes, type);
        return bytes;
    }

    public static int getNbBytesInSignedValue(long value) {
        int nbBits = 65 - Long.numberOfLeadingZeros(value ^ value >> 63);
        return nbBits + 7 >> 3;
    }

    public static int getNbBytesInSignedValue(int value) {
        int nbBits = 33 - Integer.numberOfLeadingZeros(value ^ value >> 31);
        return nbBits + 7 >> 3;
    }

    public static int getNbBytesForRightZeroExtendedValue(long value) {
        int requiredBits = 64 - Long.numberOfTrailingZeros(value);
        if (requiredBits == 0) {
            requiredBits = 1;
        }
        return requiredBits + 7 >> 3;
    }

    public static int getTypeFromDescriptor(String desc) {
        int result = 0;
        switch (desc.charAt(0)) {
            case 'Z': {
                result = 31;
                break;
            }
            case 'B': {
                result = 0;
                break;
            }
            case 'S': {
                result = 2;
                break;
            }
            case 'C': {
                result = 3;
                break;
            }
            case 'I': {
                result = 4;
                break;
            }
            case 'J': {
                result = 6;
                break;
            }
            case 'F': {
                result = 16;
                break;
            }
            case 'D': {
                result = 17;
                break;
            }
            default: {
                try {
                    throw new Exception("Unknown descriptor to convert: " + desc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static boolean isTypeAReference(String desc) {
        boolean result = false;
        switch (desc.charAt(0)) {
            case 'L': 
            case '[': {
                result = true;
            }
        }
        return result;
    }

    public static boolean isString(String desc) {
        return desc.equals("Ljava/lang/String;");
    }
}

