/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IOffsetInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IPseudoInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureCommon.Label;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class PseudoInstructionSparseSwitch
extends Instruction
implements IPseudoInstruction {
    private static final int SPARSE_SWITCH_OPCODE = 512;
    private int[] keys;
    private Label[] targets;
    private IOffsetInstruction instructionSparseSwitch;

    @Override
    public IOffsetInstruction getSourceInstruction() {
        return this.instructionSparseSwitch;
    }

    public PseudoInstructionSparseSwitch(int[] keys, Label[] targets, IOffsetInstruction instructionSparseSwitch) {
        super(512);
        this.keys = keys;
        this.targets = targets;
        this.instructionSparseSwitch = instructionSparseSwitch;
    }

    @Override
    public int getSize() {
        return this.targets.length * 8 + 2 + 2;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        int i;
        out.putShort(512);
        int size = this.targets.length;
        out.putShort(size);
        for (i = 0; i < size; ++i) {
            out.putInt(this.keys[i]);
        }
        for (i = 0; i < size; ++i) {
            out.putInt((this.targets[i].getOffset() - this.instructionSparseSwitch.getInstructionOffset()) / 2);
        }
    }
}

