/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueUtil;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class EncodedValueCharacter
extends EncodedValue {
    private int type = 3;
    private char value;

    public EncodedValueCharacter(char value) {
        this.value = value;
    }

    public EncodedValueCharacter(Object value) {
        this.value = ((Character)value).charValue();
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        int val = Character.valueOf(this.value).charValue();
        int nb1 = 0;
        int nb2 = 0;
        int size = 1;
        if (val != 0) {
            nb1 = val & 0xFF;
            if ((val >>>= 8) != 0) {
                ++size;
                nb2 = val & 0xFF;
            }
        }
        byte[] result = new byte[size + 1];
        if (size > 1) {
            result[2] = (byte)nb2;
        }
        result[1] = (byte)nb1;
        result[0] = EncodedValueUtil.encodeHeader(size, this.type);
        return result;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueCharacter) {
            EncodedValueCharacter encodedValue = (EncodedValueCharacter)o;
            result = this.type == encodedValue.type && this.value == encodedValue.value;
        }
        return result;
    }

    public int hashCode() {
        return this.type + this.value * 729;
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        if (this == encodedValue) {
            return 0;
        }
        EncodedValueCharacter ec = (EncodedValueCharacter)encodedValue;
        char value2 = ec.value;
        return this.value == value2 ? 0 : (this.value > value2 ? 1 : -1);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

