/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Instrumentation;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.support.annotation.NonNull;
import com.github.tmurakami.classinjector.ClassInjector;
import com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.ClassSourceImpl;
import com.github.tmurakami.dexopener.DexClassFileFactory;
import com.github.tmurakami.dexopener.DexClassSourceFactory;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexOpener;
import java.io.File;
import java.util.logging.Logger;

final class DexOpenerImpl
extends DexOpener {
    private final ClassNameFilter classNameFilter;
    private final DexFileLoader dexFileLoader;
    private final DexClassFileFactory dexClassFileFactory;

    DexOpenerImpl(ClassNameFilter classNameFilter, DexFileLoader dexFileLoader, DexClassFileFactory dexClassFileFactory) {
        this.classNameFilter = classNameFilter;
        this.dexFileLoader = dexFileLoader;
        this.dexClassFileFactory = dexClassFileFactory;
    }

    @Override
    public void install(@NonNull Instrumentation instrumentation) {
        Context context = instrumentation.getTargetContext();
        if (context == null) {
            throw new IllegalStateException("The instrumentation has not been initialized yet");
        }
        if (context.getApplicationContext() != null) {
            throw new IllegalStateException("An Application instance has already been created");
        }
        ApplicationInfo ai = context.getApplicationInfo();
        File cacheDir = new File(ai.dataDir, "code_cache/dexopener");
        if (cacheDir.isDirectory()) {
            DexOpenerImpl.deleteFiles(cacheDir.listFiles());
        }
        ClassInjector.from((ClassSource)new ClassSourceImpl(ai.sourceDir, this.classNameFilter, new DexClassSourceFactory(cacheDir, this.classNameFilter, this.dexFileLoader, this.dexClassFileFactory))).into(context.getClassLoader());
    }

    private static void deleteFiles(File[] files) {
        for (File f : files) {
            if (f.isDirectory()) {
                DexOpenerImpl.deleteFiles(f.listFiles());
            }
            if (!f.exists() || f.delete()) continue;
            Logger.getLogger("com.github.tmurakami.dexopener").warning("Cannot delete " + f);
        }
    }
}

