/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.BasicDexFileReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureReader.ClassDefinitionItem;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureReader.FieldIdItem;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureReader.MethodIdItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;

public class DexFileReader
extends BasicDexFileReader
implements IDalvikValueReader {
    private byte[] contents;
    protected int pos = 0;

    @Override
    public void parse(byte[] dexBytes) throws IOException {
        super.parse(dexBytes);
        this.contents = dexBytes;
    }

    public HashMap<Integer, Integer> fillOffsetHashMap(int nbFields) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(nbFields);
        for (int i = 0; i < nbFields; ++i) {
            map.put(this.uint(), this.uint());
        }
        return map;
    }

    public String getStringItemFromStringIndex(int index) {
        return this.constantPoolStrings[index];
    }

    public String getStringItemFromTypeIndex(int index) {
        return this.constantPoolTypes[index];
    }

    public String getNameFromMethodIndex(int index) {
        int saveReaderPosition = this.getPos();
        this.seek(this.getOffsetMethodIdItem(index) + 4);
        String result = this.getStringItemFromStringIndex(this.uint());
        this.seek(saveReaderPosition);
        return result;
    }

    public String getShortyStringFromProtoIndex(int index) {
        int saveReaderPosition = this.getPos();
        this.seek(this.getOffsetProtoIdItem(index));
        String result = this.getStringItemFromStringIndex(this.uint());
        this.seek(saveReaderPosition);
        return result;
    }

    public String getNameFromFieldIndex(int index) {
        int saveReaderPosition = this.getPos();
        this.seek(this.getOffsetFieldIdItem(index) + 4);
        String result = this.getStringItemFromStringIndex(this.uint());
        this.seek(saveReaderPosition);
        return result;
    }

    public String getTypeNameFromFieldIndex(int index) {
        int saveReaderPosition = this.getPos();
        this.seek(this.getOffsetFieldIdItem(index));
        this.skipShort();
        String result = this.getStringItemFromTypeIndex(this.ushort());
        this.seek(saveReaderPosition);
        return result;
    }

    public int[] getTypeIdIndexesFromTypeList() {
        int nbEntries = this.uint();
        int[] indexes = new int[nbEntries];
        for (int i = 0; i < nbEntries; ++i) {
            indexes[i] = this.ushort();
        }
        return indexes;
    }

    public int[] getAnnotationItemOffsetsFromAnnotationSetItem() {
        int nbEntries = this.uint();
        int[] offsets = new int[nbEntries];
        for (int i = 0; i < nbEntries; ++i) {
            offsets[i] = this.uint();
        }
        return offsets;
    }

    public String getDescriptorFromPrototypeIndex(int prototypeIndex) {
        int savedPosition = this.getPos();
        this.seek(this.getOffsetProtoIdItem(prototypeIndex));
        this.skipInt();
        StringBuilder methodDescriptor = new StringBuilder();
        methodDescriptor.append(this.getStringItemFromTypeIndex(this.uint()));
        int parametersListOffset = this.uint();
        if (parametersListOffset != 0) {
            this.seek(parametersListOffset);
            int[] parameterIndexes = this.getTypeIdIndexesFromTypeList();
            int parameterIndexesSize = parameterIndexes.length;
            for (int paramIndex = 0; paramIndex < parameterIndexesSize; ++paramIndex) {
                methodDescriptor.append(this.getStringItemFromTypeIndex(parameterIndexes[paramIndex]));
            }
        }
        this.seek(savedPosition);
        return methodDescriptor.toString();
    }

    public MethodIdItem getMethodIdItem(int methodId) {
        this.seek(this.getOffsetMethodIdItem(methodId));
        return new MethodIdItem(this.ushort(), this.ushort(), this.uint());
    }

    public FieldIdItem getFieldIdItem(int index) {
        this.seek(this.getOffsetFieldIdItem(index));
        return new FieldIdItem(this.ushort(), this.ushort(), this.uint());
    }

    public ClassDefinitionItem getClassDefinitionItem(int classIndex) {
        return new ClassDefinitionItem(this, classIndex, this.getClassDefinitionOffset(classIndex));
    }

    public static final int sint(InputStream stream) throws IOException {
        byte[] contents = new byte[4];
        if (stream.read(contents) != 4) {
            throw new RuntimeException("Cannot read integer");
        }
        return contents[0] & 0xFF | (contents[1] & 0xFF) << 8 | (contents[2] & 0xFF) << 16 | (contents[3] & 0xFF) << 24;
    }

    @Override
    public final byte sbyte() {
        return this.contents[this.pos++];
    }

    @Override
    public final short ubyte() {
        return (short)(this.contents[this.pos++] & 0xFF);
    }

    @Override
    public final short sshort() {
        short v = (short)(this.contents[this.pos] & 0xFF | (this.contents[this.pos + 1] & 0xFF) << 8);
        this.pos += 2;
        return v;
    }

    @Override
    public final int ushort() {
        return this.contents[this.pos++] & 0xFF | (this.contents[this.pos++] & 0xFF) << 8;
    }

    @Override
    public final int sint() {
        int v = this.contents[this.pos] & 0xFF | (this.contents[this.pos + 1] & 0xFF) << 8 | (this.contents[this.pos + 2] & 0xFF) << 16 | (this.contents[this.pos + 3] & 0xFF) << 24;
        this.pos += 4;
        return v;
    }

    @Override
    public final int uint() {
        int v = this.contents[this.pos] & 0xFF | (this.contents[this.pos + 1] & 0xFF) << 8 | (this.contents[this.pos + 2] & 0xFF) << 16 | (this.contents[this.pos + 3] & 0xFF) << 24;
        this.pos += 4;
        return v;
    }

    @Override
    public final int sleb128() {
        int v = this.contents[this.pos++] & 0xFF;
        int r = v & 0x7F;
        if (v >= 128) {
            v = this.contents[this.pos++] & 0xFF;
            r |= (v & 0x7F) << 7;
            if (v >= 128) {
                v = this.contents[this.pos++] & 0xFF;
                r |= (v & 0x7F) << 14;
                if (v >= 128) {
                    v = this.contents[this.pos++] & 0xFF;
                    r |= (v & 0x7F) << 21;
                    if (v >= 128) {
                        v = this.contents[this.pos++] & 0xFF;
                        r |= (v & 0x7F) << 28;
                        if (v >= 128) {
                            throw new RuntimeException("Bad sleb128");
                        }
                    } else if ((v & 0x40) != 0) {
                        r |= 0xF0000000;
                    }
                } else if ((v & 0x40) != 0) {
                    r |= 0xFFE00000;
                }
            } else if ((v & 0x40) != 0) {
                r |= 0xFFFFC000;
            }
        } else if ((v & 0x40) != 0) {
            r |= 0xFFFFFF80;
        }
        return r;
    }

    @Override
    public final int uleb128() {
        int v = this.contents[this.pos++] & 0xFF;
        int r = v & 0x7F;
        if (v >= 128) {
            v = this.contents[this.pos++] & 0xFF;
            r |= (v & 0x7F) << 7;
            if (v >= 128) {
                v = this.contents[this.pos++] & 0xFF;
                r |= (v & 0x7F) << 14;
                if (v >= 128) {
                    v = this.contents[this.pos++] & 0xFF;
                    r |= (v & 0x7F) << 21;
                    if (v >= 128) {
                        v = this.contents[this.pos++] & 0xFF;
                        r |= (v & 0x7F) << 28;
                        if (v >= 128) {
                            throw new RuntimeException("Bad uleb128");
                        }
                    }
                }
            }
        }
        return r;
    }

    @Override
    public final int uleb128_p1() {
        return this.uleb128() - 1;
    }

    @Override
    public final long uleb128_16() {
        int v = this.ushort();
        long r = v & Short.MAX_VALUE;
        if (v > 32768) {
            v = this.ushort();
            r |= (long)((v & Short.MAX_VALUE) << 15);
        }
        return r;
    }

    @Override
    public final long sizedLong(int sz) {
        long result = 0L;
        int length = sz + 1;
        for (int i = 0; i < length; ++i) {
            short v = this.ubyte();
            result |= (long)v << 8 * i;
        }
        return result;
    }

    @Override
    public final long completeSignSizedLong(long l, int sz) {
        int shift = (8 - ++sz) * 8;
        return l << shift >> shift;
    }

    public void bytes(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.contents[this.pos + i];
        }
        this.pos += b.length;
    }

    @Override
    public String utf8String() {
        int c;
        StringBuilder buf = new StringBuilder();
        while ((c = this.contents[this.pos++] & 0xFF) != 0) {
            if ((c & 0x80) == 128) {
                int v;
                if ((c & 0xE0) == 192) {
                    c &= 0x1F;
                    v = this.contents[this.pos++] & 0x3F;
                    c = c << 6 | v;
                } else if ((c & 0xF0) == 224) {
                    v = this.contents[this.pos++] & 0x3F;
                    c = c << 6 | v;
                    v = this.contents[this.pos++] & 0x3F;
                    c = c << 6 | v;
                } else {
                    System.out.println("Bad (point 4) UTF 8 " + Integer.toBinaryString(c));
                }
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    @Override
    public final void seek(int pos) {
        this.pos = pos;
    }

    @Override
    public void relativeSeek(int offset) {
        this.pos += offset;
    }

    @Override
    public final int getPos() {
        return this.pos;
    }

    @Override
    public String unicodeString(int strSize) {
        char[] content = new char[strSize];
        for (int i = 0; i < strSize; ++i) {
            content[i] = (char)this.ushort();
        }
        int c = this.ushort();
        if (c != 0) {
            System.out.println("Did not find the ending character\n " + Arrays.toString(content) + " " + c);
        }
        return new String(content);
    }

    @Override
    public final boolean hasMore() {
        return this.pos < this.contents.length;
    }

    int peek(int i) {
        return this.contents[i] & 0xFF;
    }

    @Override
    public final void skipInt() {
        this.pos += 4;
    }

    @Override
    public final void skipShort() {
        this.pos += 2;
    }

    @Override
    public final void skipByte() {
        ++this.pos;
    }

    @Override
    public byte[] getContents() {
        return this.contents;
    }
}

