/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.MethodVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat10T;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat11N;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat11X;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat12X;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat20T;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat21C;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat21H;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat21S;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat21T;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat22B;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat22C;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat22S;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat22T;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat22X;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat23X;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat30T;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat31C;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat31I;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat31T;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat32X;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat35C;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat3RC;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.InstructionFormat51L;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.DexFileReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureCommon.Label;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureCommon.LocalVariable;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureReader.ISwitchCase;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureReader.PackedSwitch;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureReader.SparseSwitch;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureReader.TryCatch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MethodCodeReader {
    protected MethodVisitor methodVisitor;
    protected DexFileReader dexFile;
    protected int codeOffset;
    protected boolean skipDebug;
    protected int instructionsStartOffset;
    protected int instructionsEndOffset;
    protected HashMap<Integer, Label> labels;
    protected HashMap<Integer, PackedSwitch> packedSwitchStructures;
    protected HashMap<Integer, SparseSwitch> sparseSwitchStructures;
    protected HashMap<Integer, ArrayList<TryCatch>> listTryCatchStructures;
    protected HashMap<Integer, List<LocalVariable>> localVariableLists;
    private HashMap<Integer, Integer> registerArrayType = new HashMap();
    protected int debugAddress;
    protected int debugLine;
    protected String debugSourceFile;
    protected boolean debugPrologueEnd;
    protected boolean debugEpilogueBegin;
    protected int debugLineAtInitialization;
    protected int debugCurrentOpcodeOffsetAtInitialization;
    protected int debugCurrentOpcodeOffset;
    protected boolean newDebugLineEmitted;
    protected int debugEmittedLine;
    private static final int TRY_ITEM_STRUCTURE_SIZE = 8;
    private boolean hasReachedPseudoInstructions = false;

    public MethodCodeReader(DexFileReader dexFile, MethodVisitor methodVisitor, int codeOffset, boolean skipDebug) {
        this.dexFile = dexFile;
        this.methodVisitor = methodVisitor;
        this.codeOffset = codeOffset;
        this.skipDebug = skipDebug;
    }

    public void visitMethodCode() {
        if (this.codeOffset != 0) {
            this.dexFile.seek(this.codeOffset);
            int registerSize = this.dexFile.ushort();
            this.dexFile.skipShort();
            this.dexFile.skipShort();
            int triesSize = this.dexFile.ushort();
            int debugInfoOffset = this.dexFile.uint();
            int instructionsSizeInUShort = this.dexFile.uint();
            this.instructionsStartOffset = this.dexFile.getPos();
            this.instructionsEndOffset = this.instructionsStartOffset + instructionsSizeInUShort * 2;
            this.labels = new HashMap();
            this.packedSwitchStructures = new HashMap();
            this.sparseSwitchStructures = new HashMap();
            this.listTryCatchStructures = new HashMap(triesSize);
            this.localVariableLists = new HashMap();
            if (!this.skipDebug && debugInfoOffset != 0) {
                this.dexFile.seek(debugInfoOffset);
                this.debugLineAtInitialization = this.dexFile.uleb128();
                int debugParametersSize = this.dexFile.uleb128();
                if (debugParametersSize > 0) {
                    String[] parameters = new String[debugParametersSize];
                    for (int indexParameter = 0; indexParameter < debugParametersSize; ++indexParameter) {
                        int stringIndex = this.dexFile.uleb128_p1();
                        String paramName = stringIndex == -1 ? "" : this.dexFile.getStringItemFromStringIndex(stringIndex);
                        parameters[indexParameter] = paramName;
                    }
                    this.methodVisitor.visitParameters(parameters);
                }
                this.debugCurrentOpcodeOffsetAtInitialization = this.dexFile.getPos();
            }
            this.methodVisitor.visitCode();
            this.methodVisitor.visitMaxs(registerSize, 0);
            if (triesSize != 0) {
                this.dexFile.seek(this.instructionsEndOffset);
                if (instructionsSizeInUShort % 2 != 0) {
                    this.dexFile.ushort();
                }
                this.parseTryItemsFormat(this.dexFile.getPos(), triesSize);
            }
            this.parseCodeInstructions(this.methodVisitor, this.skipDebug, true);
            this.parseCodeInstructions(this.methodVisitor, this.skipDebug, false);
            for (List<LocalVariable> localVariableList : this.localVariableLists.values()) {
                for (LocalVariable localVariable : localVariableList) {
                    this.methodVisitor.visitLocalVariable(localVariable.getName(), localVariable.getType(), localVariable.getSignature(), localVariable.getStart(), localVariable.getEnds(), localVariable.getRestarts(), localVariable.getRegister());
                }
            }
        }
    }

    private void parseCodeInstructions(MethodVisitor methodVisitor, boolean skipDebug, boolean findLabelsOnly) {
        this.hasReachedPseudoInstructions = false;
        this.debugCurrentOpcodeOffset = this.debugCurrentOpcodeOffsetAtInitialization;
        this.debugAddress = 0;
        this.debugLine = this.debugLineAtInitialization;
        this.debugEmittedLine = 0;
        this.debugSourceFile = null;
        this.debugPrologueEnd = false;
        this.debugEpilogueBegin = false;
        this.newDebugLineEmitted = false;
        this.dexFile.seek(this.instructionsStartOffset);
        block47: while (this.dexFile.getPos() < this.instructionsEndOffset) {
            int relativeOffset = this.dexFile.getPos() - this.instructionsStartOffset;
            if (!skipDebug && this.debugCurrentOpcodeOffset >= 0) {
                this.parseDebugInformationItem(methodVisitor, relativeOffset, findLabelsOnly);
            }
            if (this.labels.containsKey(relativeOffset)) {
                Label label = this.labels.get(relativeOffset);
                if (this.newDebugLineEmitted) {
                    label.setLine(this.debugEmittedLine);
                }
                if (!findLabelsOnly) {
                    methodVisitor.visitLabel(label);
                }
            }
            if (this.newDebugLineEmitted) {
                if (!findLabelsOnly) {
                    methodVisitor.visitLineNumber(this.debugEmittedLine, this.getLabel(relativeOffset));
                }
                this.newDebugLineEmitted = false;
            }
            if (this.listTryCatchStructures.containsKey(relativeOffset)) {
                ArrayList<TryCatch> listTryCatch = this.listTryCatchStructures.get(relativeOffset);
                for (TryCatch tcs : listTryCatch) {
                    if (findLabelsOnly) continue;
                    methodVisitor.visitTryCatchBlock(tcs.getStart(), tcs.getEnd(), tcs.getHandler(), tcs.getType());
                }
            }
            int fullOpcode = this.dexFile.ushort();
            int shortOpcode = fullOpcode & 0xFF;
            int highOrderByte = fullOpcode >> 8 & 0xFF;
            if (shortOpcode == 0) {
                switch (highOrderByte) {
                    case 0: {
                        if (findLabelsOnly || this.hasReachedPseudoInstructions) continue block47;
                        methodVisitor.visitInsn(shortOpcode);
                        continue block47;
                    }
                    case 1: {
                        int packedSwitchSize = this.dexFile.ushort();
                        this.dexFile.seek(this.dexFile.getPos() + packedSwitchSize * 4 + 4);
                        this.hasReachedPseudoInstructions = true;
                        continue block47;
                    }
                    case 2: {
                        int sparseSwitchSize = this.dexFile.ushort();
                        this.dexFile.seek(this.dexFile.getPos() + sparseSwitchSize * 4 * 2);
                        this.hasReachedPseudoInstructions = true;
                        continue block47;
                    }
                    case 3: {
                        int elementWidth = this.dexFile.ushort();
                        int elementSize = this.dexFile.uint();
                        int totalSizeInBytes = elementWidth * elementSize;
                        int codeUnitNumber = (totalSizeInBytes + 1) / 2;
                        this.dexFile.seek(this.dexFile.getPos() + codeUnitNumber * 2);
                        this.hasReachedPseudoInstructions = true;
                        continue block47;
                    }
                }
                throw new RuntimeException("Unknown opcode after a 0x00 : 0x" + Integer.toHexString(highOrderByte) + " at " + Integer.toHexString(this.dexFile.getPos() - 2));
            }
            this.hasReachedPseudoInstructions = false;
            switch (shortOpcode) {
                case 1: 
                case 4: 
                case 7: {
                    if (findLabelsOnly) break;
                    int regA = InstructionFormat12X.getRegisterA(fullOpcode);
                    int regB = InstructionFormat12X.getRegisterB(fullOpcode);
                    this.visitVarInsn(shortOpcode, methodVisitor, regA, regB);
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    if (findLabelsOnly) {
                        InstructionFormat22X.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat22X.getRegisterA(fullOpcode);
                    int regB = InstructionFormat22X.getRegisterB(this.dexFile);
                    this.visitVarInsn(shortOpcode, methodVisitor, regA, regB);
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    if (findLabelsOnly) {
                        InstructionFormat32X.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat32X.getRegisterA(this.dexFile);
                    int regB = InstructionFormat32X.getRegisterB(this.dexFile);
                    this.visitVarInsn(shortOpcode, methodVisitor, regA, regB);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 29: 
                case 30: 
                case 39: {
                    if (findLabelsOnly) break;
                    int regA = InstructionFormat11X.getRegisterA(fullOpcode);
                    methodVisitor.visitIntInsn(shortOpcode, regA);
                    break;
                }
                case 14: {
                    if (findLabelsOnly) continue block47;
                    methodVisitor.visitInsn(shortOpcode);
                    break;
                }
                case 18: {
                    if (findLabelsOnly) break;
                    int regA = InstructionFormat11N.getRegisterA(fullOpcode);
                    int literalB = InstructionFormat11N.getLiteralB(fullOpcode);
                    this.visitVarInsn(shortOpcode, methodVisitor, regA, literalB);
                    break;
                }
                case 19: 
                case 22: {
                    if (findLabelsOnly) {
                        InstructionFormat21S.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat21S.getRegisterA(fullOpcode);
                    int literalB = InstructionFormat21S.getLiteralB(this.dexFile);
                    this.visitVarInsn(shortOpcode, methodVisitor, regA, literalB);
                    break;
                }
                case 20: 
                case 23: {
                    if (findLabelsOnly) {
                        InstructionFormat31I.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat31I.getRegisterA(fullOpcode);
                    int literalB = InstructionFormat31I.getLiteralB(this.dexFile);
                    this.visitVarInsn(shortOpcode, methodVisitor, regA, literalB);
                    break;
                }
                case 21: {
                    if (findLabelsOnly) {
                        InstructionFormat21H.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat21H.getRegisterA(fullOpcode);
                    int literalB = InstructionFormat21H.getLiteralB(this.dexFile);
                    this.visitVarInsn(shortOpcode, methodVisitor, regA, literalB << 16);
                    break;
                }
                case 25: {
                    if (findLabelsOnly) {
                        InstructionFormat21H.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat21H.getRegisterA(fullOpcode);
                    int literalB = InstructionFormat21H.getLiteralB(this.dexFile);
                    this.visitVarInsn(shortOpcode, methodVisitor, regA, (long)literalB << 48);
                    break;
                }
                case 24: {
                    if (findLabelsOnly) {
                        InstructionFormat51L.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat51L.getRegisterA(fullOpcode);
                    long literalB = InstructionFormat51L.getLiteralB(this.dexFile);
                    methodVisitor.visitVarInsn(shortOpcode, regA, literalB);
                    break;
                }
                case 26: {
                    if (findLabelsOnly) {
                        InstructionFormat21C.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat21C.getRegisterA(fullOpcode);
                    int indexB = InstructionFormat21C.getIndexB(this.dexFile);
                    String string = this.dexFile.getStringItemFromStringIndex(indexB);
                    methodVisitor.visitStringInsn(shortOpcode, regA, string);
                    break;
                }
                case 27: {
                    if (findLabelsOnly) {
                        InstructionFormat31C.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat31C.getRegisterA(fullOpcode);
                    int indexB = InstructionFormat31C.getIndexB(this.dexFile);
                    String string = this.dexFile.getStringItemFromStringIndex(indexB);
                    methodVisitor.visitStringInsn(shortOpcode, regA, string);
                    break;
                }
                case 28: {
                    if (findLabelsOnly) {
                        InstructionFormat21C.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat21C.getRegisterA(fullOpcode);
                    int indexB = InstructionFormat21C.getIndexB(this.dexFile);
                    String typeName = this.dexFile.getStringItemFromTypeIndex(indexB);
                    methodVisitor.visitTypeInsn(shortOpcode, regA, 0, 0, typeName);
                    break;
                }
                case 31: {
                    if (findLabelsOnly) {
                        InstructionFormat21C.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat21C.getRegisterA(fullOpcode);
                    int indexB = InstructionFormat21C.getIndexB(this.dexFile);
                    String typeName = this.dexFile.getStringItemFromTypeIndex(indexB);
                    methodVisitor.visitTypeInsn(shortOpcode, 0, regA, 0, typeName);
                    break;
                }
                case 32: {
                    if (findLabelsOnly) {
                        InstructionFormat22C.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat22C.getRegisterA(fullOpcode);
                    int regB = InstructionFormat22C.getRegisterB(fullOpcode);
                    int indexC = InstructionFormat22C.getIndexC(this.dexFile);
                    String typeName = this.dexFile.getStringItemFromTypeIndex(indexC);
                    methodVisitor.visitTypeInsn(shortOpcode, regA, regB, 0, typeName);
                    break;
                }
                case 33: {
                    if (findLabelsOnly) break;
                    int regA = InstructionFormat12X.getRegisterA(fullOpcode);
                    int regB = InstructionFormat12X.getRegisterB(fullOpcode);
                    methodVisitor.visitArrayLengthInsn(regA, regB);
                    break;
                }
                case 34: {
                    if (findLabelsOnly) {
                        InstructionFormat21C.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat21C.getRegisterA(fullOpcode);
                    int indexB = InstructionFormat21C.getIndexB(this.dexFile);
                    String typeName = this.dexFile.getStringItemFromTypeIndex(indexB);
                    methodVisitor.visitTypeInsn(shortOpcode, regA, 0, 0, typeName);
                    break;
                }
                case 35: {
                    if (findLabelsOnly) {
                        InstructionFormat22C.skip(this.dexFile);
                        break;
                    }
                    int registerArray = InstructionFormat22C.getRegisterA(fullOpcode);
                    int regB = InstructionFormat22C.getRegisterB(fullOpcode);
                    int indexC = InstructionFormat22C.getIndexC(this.dexFile);
                    String typeName = this.dexFile.getStringItemFromTypeIndex(indexC);
                    methodVisitor.visitTypeInsn(shortOpcode, registerArray, 0, regB, typeName);
                    int type = MethodCodeReader.getTypeFromTypeArray(typeName);
                    this.registerArrayType.put(registerArray, type);
                    break;
                }
                case 36: {
                    if (findLabelsOnly) {
                        InstructionFormat35C.skip(this.dexFile);
                        break;
                    }
                    int index = InstructionFormat35C.getIndex(this.dexFile);
                    int[] registers = InstructionFormat35C.getRegisters(this.dexFile, fullOpcode);
                    this.visitMultiANewArrayInsn(methodVisitor, index, registers);
                    break;
                }
                case 37: {
                    if (findLabelsOnly) {
                        InstructionFormat3RC.skip(this.dexFile);
                        break;
                    }
                    int index = InstructionFormat3RC.getIndex(this.dexFile);
                    int[] registers = InstructionFormat3RC.getRegisters(this.dexFile, fullOpcode);
                    this.visitMultiANewArrayInsn(methodVisitor, index, registers);
                    break;
                }
                case 38: {
                    if (findLabelsOnly) {
                        InstructionFormat31T.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat31T.getRegisterA(fullOpcode);
                    int offset = InstructionFormat31T.getOffset(this.dexFile, fullOpcode);
                    this.visitFillArrayData(methodVisitor, regA, offset);
                    break;
                }
                case 40: {
                    int offset = InstructionFormat10T.getOffset(this.dexFile, fullOpcode);
                    this.visitJumpInsn(shortOpcode, offset, 0, 0, methodVisitor, findLabelsOnly);
                    break;
                }
                case 41: {
                    int offset = InstructionFormat20T.getOffset(this.dexFile, fullOpcode);
                    this.visitJumpInsn(shortOpcode, offset, 0, 0, methodVisitor, findLabelsOnly);
                    break;
                }
                case 42: {
                    int offset = InstructionFormat30T.getOffset(this.dexFile, fullOpcode);
                    this.visitJumpInsn(shortOpcode, offset, 0, 0, methodVisitor, findLabelsOnly);
                    break;
                }
                case 43: 
                case 44: {
                    this.parseAndVisitSwitchCase(methodVisitor, fullOpcode, findLabelsOnly);
                    break;
                }
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    if (findLabelsOnly) {
                        InstructionFormat23X.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat23X.getRegisterA(fullOpcode);
                    int regBAndC = InstructionFormat23X.getEncodedRegisterBAndC(this.dexFile);
                    int regB = InstructionFormat23X.getRegisterBFromEncodedRegisterBAndC(regBAndC);
                    int regC = InstructionFormat23X.getRegisterCFromEncodedRegisterBAndC(regBAndC);
                    methodVisitor.visitOperationInsn(shortOpcode, regA, regB, regC, 0);
                    break;
                }
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    int regA = InstructionFormat22T.getRegisterA(fullOpcode);
                    int regB = InstructionFormat22T.getRegisterB(fullOpcode);
                    int offset = InstructionFormat22T.getOffset(this.dexFile, fullOpcode);
                    this.visitJumpInsn(shortOpcode, offset, regA, regB, methodVisitor, findLabelsOnly);
                    break;
                }
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: {
                    int regA = InstructionFormat21T.getRegisterA(fullOpcode);
                    int offset = InstructionFormat21T.getOffset(this.dexFile, fullOpcode);
                    this.visitJumpInsn(shortOpcode, offset, regA, 0, methodVisitor, findLabelsOnly);
                    break;
                }
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: {
                    if (findLabelsOnly) {
                        InstructionFormat23X.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat23X.getRegisterA(fullOpcode);
                    int regBAndC = InstructionFormat23X.getEncodedRegisterBAndC(this.dexFile);
                    int regB = InstructionFormat23X.getRegisterBFromEncodedRegisterBAndC(regBAndC);
                    int regC = InstructionFormat23X.getRegisterCFromEncodedRegisterBAndC(regBAndC);
                    methodVisitor.visitArrayOperationInsn(shortOpcode, regA, regB, regC);
                    break;
                }
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    if (findLabelsOnly) {
                        InstructionFormat22C.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat22C.getRegisterA(fullOpcode);
                    int regB = InstructionFormat22C.getRegisterB(fullOpcode);
                    int indexC = InstructionFormat22C.getIndexC(this.dexFile);
                    this.visitFieldInsn(methodVisitor, shortOpcode, regA, regB, indexC);
                    break;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: {
                    if (findLabelsOnly) {
                        InstructionFormat21C.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat21C.getRegisterA(fullOpcode);
                    int indexC = InstructionFormat21C.getIndexB(this.dexFile);
                    this.visitFieldInsn(methodVisitor, shortOpcode, regA, 0, indexC);
                    break;
                }
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: {
                    if (findLabelsOnly) {
                        InstructionFormat35C.skip(this.dexFile);
                        break;
                    }
                    int index = InstructionFormat35C.getIndex(this.dexFile);
                    int[] registers = InstructionFormat35C.getRegisters(this.dexFile, fullOpcode);
                    this.visitMethodInstruction(methodVisitor, shortOpcode, index, registers);
                    break;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    if (findLabelsOnly) {
                        InstructionFormat3RC.skip(this.dexFile);
                        break;
                    }
                    int index = InstructionFormat3RC.getIndex(this.dexFile);
                    int[] registers = InstructionFormat3RC.getRegisters(this.dexFile, fullOpcode);
                    this.visitMethodInstruction(methodVisitor, shortOpcode, index, registers);
                    break;
                }
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: {
                    if (findLabelsOnly) break;
                    int regA = InstructionFormat12X.getRegisterA(fullOpcode);
                    int regB = InstructionFormat12X.getRegisterB(fullOpcode);
                    methodVisitor.visitOperationInsn(shortOpcode, regA, regB, 0, 0);
                    break;
                }
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: {
                    if (findLabelsOnly) {
                        InstructionFormat23X.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat23X.getRegisterA(fullOpcode);
                    int regBAndC = InstructionFormat23X.getEncodedRegisterBAndC(this.dexFile);
                    int regB = InstructionFormat23X.getRegisterBFromEncodedRegisterBAndC(regBAndC);
                    int regC = InstructionFormat23X.getRegisterCFromEncodedRegisterBAndC(regBAndC);
                    methodVisitor.visitOperationInsn(shortOpcode, regA, regB, regC, 0);
                    break;
                }
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: {
                    if (findLabelsOnly) break;
                    int regA = InstructionFormat12X.getRegisterA(fullOpcode);
                    int regB = InstructionFormat12X.getRegisterB(fullOpcode);
                    methodVisitor.visitOperationInsn(shortOpcode, regA, regA, regB, 0);
                    break;
                }
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: {
                    if (findLabelsOnly) {
                        InstructionFormat22S.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat22S.getRegisterA(fullOpcode);
                    int regB = InstructionFormat22S.getRegisterB(fullOpcode);
                    int literalC = InstructionFormat22S.getLiteralC(this.dexFile);
                    methodVisitor.visitOperationInsn(shortOpcode, regA, regB, 0, literalC);
                    break;
                }
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: {
                    if (findLabelsOnly) {
                        InstructionFormat22B.skip(this.dexFile);
                        break;
                    }
                    int regA = InstructionFormat22B.getRegisterA(fullOpcode);
                    int regBAndLitC = InstructionFormat22B.getEncodedRegisterBAndLiteralC(this.dexFile);
                    int regB = InstructionFormat22B.getRegisterBFromEncodedRegisterBAndC(regBAndLitC);
                    int literalC = InstructionFormat22B.getLiteralCFromEncodedRegisterBAndLiteralC(regBAndLitC);
                    methodVisitor.visitOperationInsn(shortOpcode, regA, regB, 0, literalC);
                    break;
                }
                default: {
                    if (findLabelsOnly) continue block47;
                    methodVisitor.visitInsn(shortOpcode);
                }
            }
        }
    }

    private static int getTypeFromTypeArray(String typeName) {
        int result = -1;
        if (typeName.length() == 2 && typeName.startsWith("[")) {
            char t = typeName.charAt(1);
            switch (t) {
                case 'Z': {
                    result = 31;
                    break;
                }
                case 'B': {
                    result = 0;
                    break;
                }
                case 'S': {
                    result = 2;
                    break;
                }
                case 'C': {
                    result = 3;
                    break;
                }
                case 'I': {
                    result = 4;
                    break;
                }
                case 'J': {
                    result = 6;
                    break;
                }
                case 'F': {
                    result = 16;
                    break;
                }
                case 'D': {
                    result = 17;
                }
            }
        }
        return result;
    }

    protected void parseDebugInformationItem(MethodVisitor methodVisitor, int currentBytecodeOffset, boolean findLabelsOnly) {
        int saveReaderPosition = this.dexFile.getPos();
        this.dexFile.seek(this.debugCurrentOpcodeOffset);
        this.newDebugLineEmitted = false;
        boolean debugParsingContinue = true;
        while (debugParsingContinue) {
            short debugOpcode = this.dexFile.ubyte();
            switch (debugOpcode) {
                case 0: {
                    debugParsingContinue = false;
                    break;
                }
                case 1: {
                    this.debugAddress += this.dexFile.uleb128();
                    break;
                }
                case 2: {
                    this.debugLine += this.dexFile.sleb128();
                    break;
                }
                case 3: {
                    if (this.debugAddress * 2 != currentBytecodeOffset) {
                        debugParsingContinue = false;
                        break;
                    }
                    this.parseDebugStartLocalVariable(methodVisitor, currentBytecodeOffset, false, findLabelsOnly);
                    break;
                }
                case 4: {
                    if (this.debugAddress * 2 != currentBytecodeOffset) {
                        debugParsingContinue = false;
                        break;
                    }
                    this.parseDebugStartLocalVariable(methodVisitor, currentBytecodeOffset, true, findLabelsOnly);
                    break;
                }
                case 5: {
                    if (this.debugAddress * 2 != currentBytecodeOffset) {
                        debugParsingContinue = false;
                        break;
                    }
                    int registerNumber = this.dexFile.uleb128();
                    if (!findLabelsOnly) break;
                    Label endLabel = this.createAndAddLabel(this.debugAddress * 2);
                    this.addEndLabelToLocalVariableLabels(registerNumber, endLabel);
                    break;
                }
                case 6: {
                    if (this.debugAddress * 2 != currentBytecodeOffset) {
                        debugParsingContinue = false;
                        break;
                    }
                    int registerNumber = this.dexFile.uleb128();
                    if (!findLabelsOnly) break;
                    Label restartLabel = this.createAndAddLabel(this.debugAddress * 2);
                    this.addRestartLabelToLocalVariableLabels(registerNumber, restartLabel);
                    break;
                }
                case 7: {
                    this.debugPrologueEnd = true;
                    break;
                }
                case 8: {
                    this.debugEpilogueBegin = true;
                    break;
                }
                case 9: {
                    int nameIndex = this.dexFile.uleb128_p1();
                    if (nameIndex == -1) break;
                    this.debugSourceFile = this.dexFile.getStringItemFromStringIndex(nameIndex);
                    break;
                }
                default: {
                    int adjustedOpcode = debugOpcode - 10;
                    int nextDebugAddress = this.debugAddress + adjustedOpcode / 15;
                    if (currentBytecodeOffset != nextDebugAddress * 2) {
                        debugParsingContinue = false;
                        break;
                    }
                    this.debugEpilogueBegin = false;
                    this.debugPrologueEnd = false;
                    this.debugLine += -4 + adjustedOpcode % 15;
                    this.newDebugLineEmitted = true;
                    this.debugEmittedLine = this.debugLine;
                    this.debugAddress = nextDebugAddress;
                    this.createAndAddLabel(this.debugAddress * 2);
                }
            }
            if (!debugParsingContinue) continue;
            this.debugCurrentOpcodeOffset = this.dexFile.getPos();
        }
        this.dexFile.seek(saveReaderPosition);
    }

    protected void parseDebugStartLocalVariable(MethodVisitor methodVisitor, int currentBytecodeOffset, boolean isLocalExtended, boolean findLabelsOnly) {
        String variableType;
        int registerNumber = this.dexFile.uleb128();
        int variableNameIndex = this.dexFile.uleb128_p1();
        int variableTypeIndex = this.dexFile.uleb128_p1();
        int variableSignatureIndex = 0;
        if (isLocalExtended) {
            variableSignatureIndex = this.dexFile.uleb128_p1();
        }
        String variableName = variableNameIndex == -1 ? null : this.dexFile.getStringItemFromStringIndex(variableNameIndex);
        String string = variableType = variableTypeIndex == -1 ? null : this.dexFile.getStringItemFromTypeIndex(variableTypeIndex);
        String variableSignature = isLocalExtended ? (variableSignatureIndex == -1 ? null : this.dexFile.getStringItemFromStringIndex(variableSignatureIndex)) : null;
        Label startLabel = this.createAndAddLabel(currentBytecodeOffset);
        if (findLabelsOnly) {
            LocalVariable localVariable = new LocalVariable(registerNumber, variableName, variableType, variableSignature, startLabel, null, null);
            this.addNewLocalVariable(registerNumber, localVariable);
        }
    }

    protected LocalVariable getLocalVariable(int registerNumber) {
        LocalVariable localVariable;
        if (this.localVariableLists.containsKey(registerNumber)) {
            List<LocalVariable> list = this.localVariableLists.get(registerNumber);
            localVariable = list.get(list.size() - 1);
        } else {
            ArrayList<LocalVariable> list = new ArrayList<LocalVariable>(1);
            localVariable = new LocalVariable(registerNumber);
            list.add(localVariable);
            this.localVariableLists.put(registerNumber, list);
        }
        return localVariable;
    }

    protected void addNewLocalVariable(int registerNumber, LocalVariable localVariable) {
        if (this.localVariableLists.containsKey(registerNumber)) {
            List<LocalVariable> list = this.localVariableLists.get(registerNumber);
            list.add(localVariable);
        } else {
            ArrayList<LocalVariable> list = new ArrayList<LocalVariable>(1);
            list.add(localVariable);
            this.localVariableLists.put(registerNumber, list);
        }
    }

    protected void parseTryItemsFormat(int tryItemOffset, int triesSize) {
        this.dexFile.seek(tryItemOffset);
        for (int tryItemIndex = 0; tryItemIndex < triesSize; ++tryItemIndex) {
            int startAddress = this.dexFile.uint() * 2;
            int instructionCount = this.dexFile.ushort() * 2;
            int handlerOffset = this.dexFile.ushort();
            int saveReaderPositionInTryItem = this.dexFile.getPos();
            this.dexFile.seek(tryItemOffset + triesSize * 8 + handlerOffset);
            int nbCatchTypesRead = this.dexFile.sleb128();
            boolean isCatchAll = nbCatchTypesRead <= 0;
            int nbCatchTypes = Math.abs(nbCatchTypesRead);
            for (int typeAddrPairIndex = 0; typeAddrPairIndex < nbCatchTypes; ++typeAddrPairIndex) {
                int typeIndex = this.dexFile.uleb128();
                int addr = this.dexFile.uleb128() * 2;
                Label startLabel = this.createAndAddLabel(startAddress);
                Label endLabel = this.createAndAddLabel(startAddress + instructionCount);
                Label handlerLabel = this.createAndAddLabel(addr);
                TryCatch tcs = new TryCatch(startLabel, endLabel, handlerLabel, this.dexFile.getStringItemFromTypeIndex(typeIndex));
                this.addTryCatchStructure(tcs, startAddress);
            }
            if (isCatchAll) {
                int catchAllAddress = this.dexFile.uleb128() * 2;
                Label startLabel = this.createAndAddLabel(startAddress);
                Label endLabel = this.createAndAddLabel(startAddress + instructionCount);
                Label handlerLabel = this.createAndAddLabel(catchAllAddress);
                TryCatch tcs = new TryCatch(startLabel, endLabel, handlerLabel, null);
                this.addTryCatchStructure(tcs, startAddress);
            }
            this.dexFile.seek(saveReaderPositionInTryItem);
        }
    }

    protected void addLabel(int offset) {
        if (!this.labels.containsKey(offset)) {
            Label label = new Label();
            label.setOffset(offset);
            this.labels.put(offset, label);
        }
    }

    protected Label addLabel(Label label) {
        int offset = label.getOffset();
        Label returnedLabel = label;
        if (this.labels.containsKey(offset)) {
            returnedLabel = this.labels.get(offset);
        } else {
            this.labels.put(offset, label);
        }
        return returnedLabel;
    }

    protected void addLabels(Label[] labelList) {
        for (Label label : labelList) {
            this.addLabel(label);
        }
    }

    protected void addTryCatchStructure(TryCatch tcs, int relativeOffset) {
        ArrayList<TryCatch> list = this.listTryCatchStructures.get(relativeOffset);
        if (list != null) {
            list.add(tcs);
        } else {
            list = new ArrayList(1);
            list.add(tcs);
            this.listTryCatchStructures.put(relativeOffset, list);
        }
    }

    protected Label getLabel(int offset) {
        return this.labels.get(offset);
    }

    protected Label createAndAddLabel(int offset) {
        Label returnedLabel;
        if (this.labels.containsKey(offset)) {
            returnedLabel = this.labels.get(offset);
        } else {
            returnedLabel = new Label();
            returnedLabel.setOffset(offset);
            this.labels.put(offset, returnedLabel);
        }
        return returnedLabel;
    }

    protected void visitVarInsn(int opcodeByte, MethodVisitor methodVisitor, int destinationRegister, int var) {
        methodVisitor.visitVarInsn(opcodeByte, destinationRegister, var);
    }

    protected void visitVarInsn(int opcodeByte, MethodVisitor methodVisitor, int destinationRegister, long var) {
        methodVisitor.visitVarInsn(opcodeByte, destinationRegister, var);
    }

    protected void visitMethodInstruction(MethodVisitor methodVisitor, int opcodeByte, int methodIndex, int[] registers) {
        int savePosReader = this.dexFile.getPos();
        this.dexFile.seek(this.dexFile.getOffsetMethodIdItem(methodIndex));
        int classIndex = this.dexFile.ushort();
        int protoIndex = this.dexFile.ushort();
        int nameIndex = this.dexFile.uint();
        String methodOwner = this.dexFile.getStringItemFromTypeIndex(classIndex);
        String methodDescriptor = this.dexFile.getDescriptorFromPrototypeIndex(protoIndex);
        String methodName = this.dexFile.getStringItemFromStringIndex(nameIndex);
        methodVisitor.visitMethodInsn(opcodeByte, methodOwner, methodName, methodDescriptor, registers);
        this.dexFile.seek(savePosReader);
    }

    protected void visitJumpInsn(int opcode, int offset, int firstRegister, int secondRegister, MethodVisitor methodVisitor, boolean findLabelsOnly) {
        int relativeOffset = offset - this.instructionsStartOffset;
        if (findLabelsOnly) {
            this.addLabel(relativeOffset);
        } else {
            methodVisitor.visitJumpInsn(opcode, this.getLabel(relativeOffset), firstRegister, secondRegister);
        }
    }

    protected void visitFieldInsn(MethodVisitor methodVisitor, int opcode, int registerA, int registerB, int index) {
        int savePosReader = this.dexFile.getPos();
        this.dexFile.seek(this.dexFile.getOffsetFieldIdItem(index));
        int classIndex = this.dexFile.ushort();
        int typeIndex = this.dexFile.ushort();
        int nameIndex = this.dexFile.uint();
        String fieldOwner = this.dexFile.getStringItemFromTypeIndex(classIndex);
        String fieldDescriptor = this.dexFile.getStringItemFromTypeIndex(typeIndex);
        String fieldName = this.dexFile.getStringItemFromStringIndex(nameIndex);
        methodVisitor.visitFieldInsn(opcode, fieldOwner, fieldName, fieldDescriptor, registerA, registerB);
        this.dexFile.seek(savePosReader);
    }

    protected void visitMultiANewArrayInsn(MethodVisitor methodVisitor, int index, int[] registers) {
        String desc = this.dexFile.getStringItemFromTypeIndex(index);
        methodVisitor.visitMultiANewArrayInsn(desc, registers);
    }

    protected void visitFillArrayData(MethodVisitor methodVisitor, int register, int offset) {
        Serializable[] elements;
        int saveReaderPosition = this.dexFile.getPos();
        int type = -1;
        if (this.registerArrayType.containsKey(register)) {
            type = this.registerArrayType.get(register);
        }
        this.dexFile.seek(offset);
        this.dexFile.skipShort();
        if (type == -1) {
            switch (this.dexFile.sshort()) {
                case 1: {
                    type = 0;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 4: {
                    type = 4;
                    break;
                }
                case 8: {
                    type = 6;
                    break;
                }
            }
        } else {
            this.dexFile.skipShort();
        }
        int elementSize = this.dexFile.uint();
        switch (type) {
            case 0: {
                elements = new Byte[elementSize];
                for (int i = 0; i < elementSize; ++i) {
                    elements[i] = Byte.valueOf(this.dexFile.sbyte());
                }
                break;
            }
            case 2: {
                elements = new Short[elementSize];
                for (int i = 0; i < elementSize; ++i) {
                    elements[i] = Short.valueOf(this.dexFile.sshort());
                }
                break;
            }
            case 3: {
                elements = new Character[elementSize];
                for (int i = 0; i < elementSize; ++i) {
                    elements[i] = Character.valueOf((char)this.dexFile.sshort());
                }
                break;
            }
            case 4: {
                elements = new Integer[elementSize];
                for (int i = 0; i < elementSize; ++i) {
                    elements[i] = Integer.valueOf(this.dexFile.sint());
                }
                break;
            }
            case 16: {
                elements = new Float[elementSize];
                for (int i = 0; i < elementSize; ++i) {
                    elements[i] = Float.valueOf(Float.intBitsToFloat((int)this.dexFile.sizedLong(3)));
                }
                break;
            }
            case 17: {
                elements = new Double[elementSize];
                for (int i = 0; i < elementSize; ++i) {
                    elements[i] = Double.valueOf(Double.longBitsToDouble(this.dexFile.sizedLong(7)));
                }
                break;
            }
            case 6: {
                elements = new Long[elementSize];
                for (int i = 0; i < elementSize; ++i) {
                    elements[i] = Long.valueOf(this.dexFile.sizedLong(7));
                }
                break;
            }
            case 31: {
                elements = new Boolean[elementSize];
                for (int i = 0; i < elementSize; ++i) {
                    elements[i] = Boolean.valueOf(this.dexFile.sbyte() != 0);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("This type (" + type + ") can't be encoded in an Array of primitive.");
            }
        }
        methodVisitor.visitFillArrayDataInsn(register, elements);
        this.dexFile.seek(saveReaderPosition);
    }

    protected void parseAndVisitSwitchCase(MethodVisitor methodVisitor, int fullOpcode, boolean findLabelsOnly) {
        boolean isPackedSwitch = (fullOpcode & 0xFF) == 43;
        int switchOffset = this.dexFile.getPos() - 2;
        int regA = InstructionFormat31T.getRegisterA(fullOpcode);
        int structureOffset = InstructionFormat31T.getOffset(this.dexFile, fullOpcode);
        if (findLabelsOnly) {
            int relativeStructureOffset = structureOffset - this.instructionsStartOffset;
            this.addLabel(relativeStructureOffset);
            int relativeSwitchOffset = switchOffset - this.instructionsStartOffset;
            ISwitchCase cs = isPackedSwitch ? this.parsePackedSwitchFormat(relativeSwitchOffset, structureOffset) : this.parseSparseSwitchFormat(relativeSwitchOffset, structureOffset);
            Label[] switchLabels = cs.getSwitchLabels();
            this.addLabels(switchLabels);
            this.addLabel(cs.getDefaultLabel());
            if (isPackedSwitch) {
                this.packedSwitchStructures.put(switchOffset, (PackedSwitch)cs);
            } else {
                this.sparseSwitchStructures.put(switchOffset, (SparseSwitch)cs);
            }
        } else if (isPackedSwitch) {
            PackedSwitch pss = this.packedSwitchStructures.get(switchOffset);
            methodVisitor.visitTableSwitchInsn(regA, pss.getValueMin(), pss.getValueMax(), pss.getDefaultLabel(), pss.getSwitchLabels());
        } else {
            SparseSwitch sss = this.sparseSwitchStructures.get(switchOffset);
            methodVisitor.visitLookupSwitchInsn(regA, sss.getDefaultLabel(), sss.getKeys(), sss.getSwitchLabels());
        }
    }

    protected PackedSwitch parsePackedSwitchFormat(int relativeSwitchOffset, int packedSwitchOffset) {
        int savedReaderPosition = this.dexFile.getPos();
        PackedSwitch pss = new PackedSwitch();
        this.dexFile.seek(packedSwitchOffset);
        this.dexFile.skipShort();
        int nbEntries = this.dexFile.ushort();
        int valueMin = this.dexFile.sint();
        Label[] switchLabels = new Label[nbEntries];
        for (int entryIndex = 0; entryIndex < nbEntries; ++entryIndex) {
            Label label;
            int labelOffset = this.dexFile.sint() * 2 + relativeSwitchOffset;
            switchLabels[entryIndex] = label = this.createAndAddLabel(labelOffset);
        }
        pss.setSwitchLabels(switchLabels);
        pss.setDefaultLabel(this.createAndAddLabel(relativeSwitchOffset + 6));
        pss.setValueMin(valueMin);
        pss.setValueMax(valueMin + nbEntries - 1);
        this.dexFile.seek(savedReaderPosition);
        return pss;
    }

    protected SparseSwitch parseSparseSwitchFormat(int relativeSwitchOffset, int sparseSwitchOffset) {
        int savedReaderPosition = this.dexFile.getPos();
        SparseSwitch sss = new SparseSwitch();
        this.dexFile.seek(sparseSwitchOffset);
        this.dexFile.skipShort();
        int nbEntries = this.dexFile.ushort();
        int[] keys = new int[nbEntries];
        for (int entryIndex = 0; entryIndex < nbEntries; ++entryIndex) {
            keys[entryIndex] = this.dexFile.sint();
        }
        Label[] switchLabels = new Label[nbEntries];
        for (int entryIndex = 0; entryIndex < nbEntries; ++entryIndex) {
            Label label;
            int labelOffset = this.dexFile.sint() * 2 + relativeSwitchOffset;
            switchLabels[entryIndex] = label = this.createAndAddLabel(labelOffset);
        }
        sss.setSwitchLabels(switchLabels);
        sss.setKeys(keys);
        sss.setDefaultLabel(this.createAndAddLabel(relativeSwitchOffset + 6));
        this.dexFile.seek(savedReaderPosition);
        return sss;
    }

    protected void addEndLabelToLocalVariableLabels(int registerNumber, Label endLabel) {
        LocalVariable localVariable = this.getLocalVariable(registerNumber);
        localVariable.addEnd(endLabel);
    }

    protected void addRestartLabelToLocalVariableLabels(int registerNumber, Label restartLabel) {
        LocalVariable localVariable = this.getLocalVariable(registerNumber);
        localVariable.addRestart(restartLabel);
    }
}

