/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class DalvikValueReader
implements IDalvikValueReader {
    private byte[] contents;
    protected int pos = 0;

    public DalvikValueReader(byte[] contents) {
        this.contents = contents;
    }

    @Override
    public byte[] getContents() {
        return this.contents;
    }

    public DalvikValueReader(byte[] dexBytes, int size_offset) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(dexBytes);
        byte[] header = new byte[size_offset];
        if (stream.read(header) != size_offset) {
            throw new IOException("Cannot skip Resource header");
        }
        int file_size = DalvikValueReader.sint(stream);
        byte[] file = new byte[file_size];
        int to_skip = size_offset + 4;
        while (file_size - to_skip != 0) {
            int read = ((InputStream)stream).read(file, to_skip, file_size - to_skip);
            if (read == 0) {
                throw new IOException("Truncated Resource file " + read + "/" + file_size + "/" + to_skip);
            }
            to_skip += read;
        }
        System.arraycopy(header, 0, file, 0, size_offset);
        this.contents = file;
    }

    public static final int sint(InputStream stream) throws IOException {
        byte[] contents = new byte[4];
        if (stream.read(contents) != 4) {
            throw new RuntimeException("Cannot read integer");
        }
        return contents[0] & 0xFF | (contents[1] & 0xFF) << 8 | (contents[2] & 0xFF) << 16 | (contents[3] & 0xFF) << 24;
    }

    @Override
    public final byte sbyte() {
        return this.contents[this.pos++];
    }

    @Override
    public final short ubyte() {
        return (short)(this.contents[this.pos++] & 0xFF);
    }

    @Override
    public final short sshort() {
        short v = (short)(this.contents[this.pos] & 0xFF | (this.contents[this.pos + 1] & 0xFF) << 8);
        this.pos += 2;
        return v;
    }

    @Override
    public final int ushort() {
        return this.contents[this.pos++] & 0xFF | (this.contents[this.pos++] & 0xFF) << 8;
    }

    @Override
    public final int sint() {
        int v = this.contents[this.pos] & 0xFF | (this.contents[this.pos + 1] & 0xFF) << 8 | (this.contents[this.pos + 2] & 0xFF) << 16 | (this.contents[this.pos + 3] & 0xFF) << 24;
        this.pos += 4;
        return v;
    }

    @Override
    public final int uint() {
        int v = this.contents[this.pos] & 0xFF | (this.contents[this.pos + 1] & 0xFF) << 8 | (this.contents[this.pos + 2] & 0xFF) << 16 | (this.contents[this.pos + 3] & 0xFF) << 24;
        this.pos += 4;
        return v;
    }

    @Override
    public final int sleb128() {
        int v = this.contents[this.pos++] & 0xFF;
        int r = v & 0x7F;
        if (v >= 128) {
            v = this.contents[this.pos++] & 0xFF;
            r |= (v & 0x7F) << 7;
            if (v >= 128) {
                v = this.contents[this.pos++] & 0xFF;
                r |= (v & 0x7F) << 14;
                if (v >= 128) {
                    v = this.contents[this.pos++] & 0xFF;
                    r |= (v & 0x7F) << 21;
                    if (v >= 128) {
                        v = this.contents[this.pos++] & 0xFF;
                        r |= (v & 0x7F) << 28;
                        if (v >= 128) {
                            throw new RuntimeException("Bad sleb128");
                        }
                    } else if ((v & 0x40) != 0) {
                        r |= 0xF0000000;
                    }
                } else if ((v & 0x40) != 0) {
                    r |= 0xFFE00000;
                }
            } else if ((v & 0x40) != 0) {
                r |= 0xFFFFC000;
            }
        } else if ((v & 0x40) != 0) {
            r |= 0xFFFFFF80;
        }
        return r;
    }

    @Override
    public final int uleb128() {
        int v = this.contents[this.pos++] & 0xFF;
        int r = v & 0x7F;
        if (v >= 128) {
            v = this.contents[this.pos++] & 0xFF;
            r |= (v & 0x7F) << 7;
            if (v >= 128) {
                v = this.contents[this.pos++] & 0xFF;
                r |= (v & 0x7F) << 14;
                if (v >= 128) {
                    v = this.contents[this.pos++] & 0xFF;
                    r |= (v & 0x7F) << 21;
                    if (v >= 128) {
                        v = this.contents[this.pos++] & 0xFF;
                        r |= (v & 0x7F) << 28;
                        if (v >= 128) {
                            throw new RuntimeException("Bad uleb128");
                        }
                    }
                }
            }
        }
        return r;
    }

    @Override
    public final int uleb128_p1() {
        return this.uleb128() - 1;
    }

    @Override
    public final long uleb128_16() {
        int v = this.ushort();
        long r = v & Short.MAX_VALUE;
        if (v > 32768) {
            v = this.ushort();
            r |= (long)((v & Short.MAX_VALUE) << 15);
        }
        return r;
    }

    @Override
    public final long sizedLong(int sz) {
        long result = 0L;
        int length = sz + 1;
        for (int i = 0; i < length; ++i) {
            short v = this.ubyte();
            result |= (long)v << 8 * i;
        }
        return result;
    }

    @Override
    public final long completeSignSizedLong(long l, int sz) {
        int shift = (8 - ++sz) * 8;
        return l << shift >> shift;
    }

    public void bytes(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.contents[this.pos + i];
        }
        this.pos += b.length;
    }

    @Override
    public String utf8String() {
        int c;
        StringBuilder buf = new StringBuilder();
        while ((c = this.contents[this.pos++] & 0xFF) != 0) {
            if ((c & 0x80) == 128) {
                int v;
                if ((c & 0xE0) == 192) {
                    c &= 0x1F;
                    v = this.contents[this.pos++] & 0x3F;
                    c = c << 6 | v;
                } else if ((c & 0xF0) == 224) {
                    v = this.contents[this.pos++] & 0x3F;
                    c = c << 6 | v;
                    v = this.contents[this.pos++] & 0x3F;
                    c = c << 6 | v;
                } else {
                    System.out.println("Bad (point 4) UTF 8 " + Integer.toBinaryString(c));
                }
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    @Override
    public final void seek(int pos) {
        this.pos = pos;
    }

    @Override
    public void relativeSeek(int offset) {
        this.pos += offset;
    }

    @Override
    public final int getPos() {
        return this.pos;
    }

    @Override
    public String unicodeString(int strSize) {
        char[] content = new char[strSize];
        for (int i = 0; i < strSize; ++i) {
            content[i] = (char)this.ushort();
        }
        int c = this.ushort();
        if (c != 0) {
            System.out.println("Did not find the ending character\n " + Arrays.toString(content) + " " + c);
        }
        return new String(content);
    }

    @Override
    public final boolean hasMore() {
        return this.pos < this.contents.length;
    }

    int peek(int i) {
        return this.contents[i] & 0xFF;
    }

    @Override
    public final void skipInt() {
        this.pos += 4;
    }

    @Override
    public final void skipShort() {
        this.pos += 2;
    }

    @Override
    public final void skipByte() {
        ++this.pos;
    }
}

