/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexElement;

final class OpenedClassLoader
extends ClassLoader {
    private final ClassLoader classLoader;
    private final ClassNameFilter classNameFilter;
    private final DexElement element;

    OpenedClassLoader(ClassLoader classLoader, ClassNameFilter classNameFilter, DexElement element) {
        super(classLoader.getParent());
        this.classLoader = classLoader;
        this.classNameFilter = classNameFilter;
        this.element = element;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class c;
        if (this.classNameFilter.accept(name) && (c = this.element.loadClass(name, this.classLoader)) != null) {
            return c;
        }
        return super.findClass(name);
    }
}

