/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.content.Context;
import com.github.tmurakami.dexopener.ClassLoaderFactory;
import com.github.tmurakami.dexopener.ClassLoaderHelperImpl;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.ClassNameFilterImpl;
import com.github.tmurakami.dexopener.DexElement;
import com.github.tmurakami.dexopener.DexElementFactoryImpl;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexGeneratorImpl;
import com.github.tmurakami.dexopener.InstallerImpl;
import com.github.tmurakami.dexopener.OpenedClassLoader;
import dalvik.system.DexFile;
import java.io.IOException;

abstract class Installer {
    Installer() {
    }

    abstract void install(Context var1);

    static Installer create() {
        ClassNameFilterImpl classNameFilter = new ClassNameFilterImpl();
        DexFileLoader fileLoader = Installer.newDexFileLoader();
        DexGeneratorImpl dexGenerator = new DexGeneratorImpl();
        DexElementFactoryImpl elementFactory = new DexElementFactoryImpl(classNameFilter, dexGenerator, fileLoader);
        ClassLoaderFactory classLoaderFactory = Installer.newClassLoaderFactory(classNameFilter);
        return new InstallerImpl(elementFactory, classLoaderFactory, new ClassLoaderHelperImpl());
    }

    private static DexFileLoader newDexFileLoader() {
        return new DexFileLoader(){

            @Override
            public DexFile load(String sourcePathName, String outputPathName) throws IOException {
                return DexFile.loadDex((String)sourcePathName, (String)outputPathName, (int)0);
            }
        };
    }

    private static ClassLoaderFactory newClassLoaderFactory(final ClassNameFilter classNameFilter) {
        return new ClassLoaderFactory(){

            @Override
            public ClassLoader newClassLoader(ClassLoader classLoader, DexElement element) {
                return new OpenedClassLoader(classLoader, classNameFilter, element);
            }
        };
    }
}

