/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import dalvik.system.DexFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

final class IOUtils {
    private IOUtils() {
        throw new AssertionError((Object)"Do not instantiate");
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void closeQuietly(DexFile dexFile) {
        if (dexFile != null) {
            try {
                dexFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void closeQuietly(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void forceDelete(File file) {
        if (file == null) {
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                IOUtils.forceDelete(f);
            }
        }
        if (file.exists() && !file.delete()) {
            Logger.getLogger("com.github.tmurakami.dexopener").warning("Cannot delete " + file);
        }
    }
}

