/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ApplicationOpener;
import com.github.tmurakami.dexopener.DexGenerator;
import com.github.tmurakami.dexopener.IOUtils;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

final class DexGeneratorImpl
implements DexGenerator {
    DexGeneratorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File generateDexFile(ApplicationReader ar, File cacheDir, String ... classesToVisit) throws IOException {
        ApplicationWriter aw = new ApplicationWriter();
        ar.accept((ApplicationVisitor)new ApplicationOpener((ApplicationVisitor)aw), classesToVisit, 0);
        byte[] bytes = aw.toByteArray();
        File zip = File.createTempFile("classes", ".zip", cacheDir);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip));
        try {
            out.setMethod(0);
            ZipEntry e = new ZipEntry("classes.dex");
            e.setSize(bytes.length);
            CRC32 crc32 = new CRC32();
            crc32.update(bytes);
            e.setCrc(crc32.getValue());
            out.putNextEntry(e);
            out.write(bytes);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
        return zip;
    }
}

