/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexElement;
import com.github.tmurakami.dexopener.DexElementFactory;
import com.github.tmurakami.dexopener.DexElementImpl;
import com.github.tmurakami.dexopener.DexElements;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexGenerator;
import com.github.tmurakami.dexopener.IOUtils;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.DexFileReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class DexElementFactoryImpl
implements DexElementFactory {
    private final ClassNameFilter classNameFilter;
    private final DexGenerator dexGenerator;
    private final DexFileLoader fileLoader;

    DexElementFactoryImpl(ClassNameFilter classNameFilter, DexGenerator dexGenerator, DexFileLoader fileLoader) {
        this.classNameFilter = classNameFilter;
        this.dexGenerator = dexGenerator;
        this.fileLoader = fileLoader;
    }

    @Override
    public DexElement newDexElement(File file, File cacheDir) {
        ArrayList<DexElement> elements = new ArrayList<DexElement>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry e = zipFile.getEntry("classes.dex");
            if (e == null) {
                throw new Error(file + " does not contain the classes.dex");
            }
            elements.add(this.newDexElement(zipFile.getInputStream(e), cacheDir));
            int i = 2;
            while ((e = zipFile.getEntry("classes" + i + ".dex")) != null) {
                elements.add(this.newDexElement(zipFile.getInputStream(e), cacheDir));
                ++i;
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(zipFile);
        return new DexElements(elements);
    }

    private DexElement newDexElement(InputStream in, File cacheDir) throws IOException {
        ApplicationReader ar = new ApplicationReader(262144, in);
        Collection<String> classNames = DexElementFactoryImpl.collectClassNames((DexFileReader)ar.getDexFile(), this.classNameFilter);
        return new DexElementImpl(ar, classNames, cacheDir, this.dexGenerator, this.fileLoader);
    }

    private static Collection<String> collectClassNames(DexFileReader r, ClassNameFilter classNameFilter) {
        int size = r.getClassDefinitionsSize();
        ArrayList<String> names = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            r.seek(r.getClassDefinitionOffset(i));
            String name = r.getStringItemFromTypeIndex(r.uint());
            if (!classNameFilter.accept(name.substring(1, name.length() - 1).replace('/', '.'))) continue;
            names.add(name);
        }
        Collections.sort(names);
        return names;
    }
}

