/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.AnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Method;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.IntEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableAnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableIntEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.AnnotationElementRewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.AnnotationRewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.ClassDefRewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.MethodRewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.Rewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.RewriterModule;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.RewriterUtils;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.Rewriters;
import java.util.Set;

final class DexOpenerRewriterModule
extends RewriterModule {
    DexOpenerRewriterModule() {
    }

    public Rewriter<Annotation> getAnnotationRewriter(Rewriters rewriters) {
        return new AnnotationRewriter(rewriters){

            public Annotation rewrite(Annotation annotation) {
                if (!annotation.getType().equals("Ldalvik/annotation/InnerClass;")) {
                    return super.rewrite(annotation);
                }
                return new AnnotationRewriter.RewrittenAnnotation(annotation){

                    public Set<? extends AnnotationElement> getElements() {
                        return RewriterUtils.rewriteSet((Rewriter)new AnnotationElementRewriter(rewriters){

                            public AnnotationElement rewrite(AnnotationElement annotationElement) {
                                String name = annotationElement.getName();
                                if (!name.equals("accessFlags")) {
                                    return annotationElement;
                                }
                                int accessFlags = ((IntEncodedValue)annotationElement.getValue()).getValue();
                                int nonFinal = accessFlags & 0xFFFFFFEF;
                                if (nonFinal == accessFlags) {
                                    return annotationElement;
                                }
                                return new ImmutableAnnotationElement(name, (EncodedValue)new ImmutableIntEncodedValue(nonFinal));
                            }
                        }, (Set)this.annotation.getElements());
                    }
                };
            }
        };
    }

    public Rewriter<ClassDef> getClassDefRewriter(Rewriters rewriters) {
        return new ClassDefRewriter(rewriters){

            public ClassDef rewrite(ClassDef classDef) {
                return new ClassDefRewriter.RewrittenClassDef(classDef){

                    public int getAccessFlags() {
                        return super.getAccessFlags() & 0xFFFFFFEF;
                    }
                };
            }
        };
    }

    public Rewriter<Method> getMethodRewriter(Rewriters rewriters) {
        return new MethodRewriter(rewriters){

            public Method rewrite(Method method) {
                return new MethodRewriter.RewrittenMethod(method){

                    public int getAccessFlags() {
                        return super.getAccessFlags() & 0xFFFFFFEF;
                    }
                };
            }
        };
    }
}

