/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexFileHolder;
import com.github.tmurakami.dexopener.DexFileHolderImpl;
import com.github.tmurakami.dexopener.DexFileTaskFactory;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableDexFile;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DexFileHolderMapper {
    private static final Opcodes OPCODES = Opcodes.getDefault();
    private static final int MAX_CLASSES_PER_DEX_FILE = 100;
    private final ClassNameFilter classNameFilter;
    private final Executor executor;
    private final DexFileTaskFactory dexFileTaskFactory;

    DexFileHolderMapper(ClassNameFilter classNameFilter, Executor executor, DexFileTaskFactory dexFileTaskFactory) {
        this.classNameFilter = classNameFilter;
        this.executor = executor;
        this.dexFileTaskFactory = dexFileTaskFactory;
    }

    void map(byte[] bytecode, Map<String, DexFileHolder> holderMap) {
        HashSet<Object> classesToBeOpened = new HashSet<ClassDef>();
        DexFileHolderImpl holder = new DexFileHolderImpl();
        for (ClassDef def : new DexBackedDexFile(OPCODES, bytecode).getClasses()) {
            String className = DexFileHolderMapper.dexToJavaName(def.getType());
            if (!this.classNameFilter.accept(className)) continue;
            Logger logger = Loggers.get();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Class to be opened: " + className);
            }
            classesToBeOpened.add(def);
            holderMap.put(className, holder);
            if (classesToBeOpened.size() != 100) continue;
            holder.setTask(this.newDexFileTask(classesToBeOpened));
            classesToBeOpened = new HashSet();
            holder = new DexFileHolderImpl();
        }
        if (!classesToBeOpened.isEmpty()) {
            holder.setTask(this.newDexFileTask(classesToBeOpened));
        }
    }

    private FutureTask<dalvik.system.DexFile> newDexFileTask(Set<ClassDef> classesToBeOpened) {
        ImmutableDexFile dexFile = new ImmutableDexFile(OPCODES, classesToBeOpened);
        FutureTask<dalvik.system.DexFile> task = this.dexFileTaskFactory.newDexFileTask((DexFile)dexFile);
        this.executor.execute(task);
        return task;
    }

    private static String dexToJavaName(String dexName) {
        return dexName.substring(1, dexName.length() - 1).replace('/', '.');
    }
}

