/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.value.BaseAnnotationEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.value.BaseArrayEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.value.BaseEnumEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.value.BaseFieldEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.value.BaseMethodEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.value.BaseTypeEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.AnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.FieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ArrayEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EnumEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.FieldEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.MethodEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.TypeEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.Rewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.RewriterUtils;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.Rewriters;
import java.util.List;
import java.util.Set;

public class EncodedValueRewriter
implements Rewriter<EncodedValue> {
    protected final Rewriters rewriters;

    public EncodedValueRewriter(Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    public EncodedValue rewrite(EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 24: {
                return new RewrittenTypeEncodedValue((TypeEncodedValue)encodedValue);
            }
            case 25: {
                return new RewrittenFieldEncodedValue((FieldEncodedValue)encodedValue);
            }
            case 26: {
                return new RewrittenMethodEncodedValue((MethodEncodedValue)encodedValue);
            }
            case 27: {
                return new RewrittenEnumEncodedValue((EnumEncodedValue)encodedValue);
            }
            case 28: {
                return new RewrittenArrayEncodedValue((ArrayEncodedValue)encodedValue);
            }
            case 29: {
                return new RewrittenAnnotationEncodedValue((AnnotationEncodedValue)encodedValue);
            }
        }
        return encodedValue;
    }

    protected class RewrittenAnnotationEncodedValue
    extends BaseAnnotationEncodedValue {
        protected AnnotationEncodedValue annotationEncodedValue;

        public RewrittenAnnotationEncodedValue(AnnotationEncodedValue annotationEncodedValue) {
            this.annotationEncodedValue = annotationEncodedValue;
        }

        @Override
        public String getType() {
            return EncodedValueRewriter.this.rewriters.getTypeRewriter().rewrite(this.annotationEncodedValue.getType());
        }

        @Override
        public Set<? extends AnnotationElement> getElements() {
            return RewriterUtils.rewriteSet(EncodedValueRewriter.this.rewriters.getAnnotationElementRewriter(), this.annotationEncodedValue.getElements());
        }
    }

    protected class RewrittenArrayEncodedValue
    extends BaseArrayEncodedValue {
        protected ArrayEncodedValue arrayEncodedValue;

        public RewrittenArrayEncodedValue(ArrayEncodedValue arrayEncodedValue) {
            this.arrayEncodedValue = arrayEncodedValue;
        }

        @Override
        public List<? extends EncodedValue> getValue() {
            return RewriterUtils.rewriteList(EncodedValueRewriter.this, this.arrayEncodedValue.getValue());
        }
    }

    protected class RewrittenMethodEncodedValue
    extends BaseMethodEncodedValue {
        protected MethodEncodedValue methodEncodedValue;

        public RewrittenMethodEncodedValue(MethodEncodedValue methodEncodedValue) {
            this.methodEncodedValue = methodEncodedValue;
        }

        @Override
        public MethodReference getValue() {
            return EncodedValueRewriter.this.rewriters.getMethodReferenceRewriter().rewrite(this.methodEncodedValue.getValue());
        }
    }

    protected class RewrittenEnumEncodedValue
    extends BaseEnumEncodedValue {
        protected EnumEncodedValue enumEncodedValue;

        public RewrittenEnumEncodedValue(EnumEncodedValue enumEncodedValue) {
            this.enumEncodedValue = enumEncodedValue;
        }

        @Override
        public FieldReference getValue() {
            return EncodedValueRewriter.this.rewriters.getFieldReferenceRewriter().rewrite(this.enumEncodedValue.getValue());
        }
    }

    protected class RewrittenFieldEncodedValue
    extends BaseFieldEncodedValue {
        protected FieldEncodedValue fieldEncodedValue;

        public RewrittenFieldEncodedValue(FieldEncodedValue fieldEncodedValue) {
            this.fieldEncodedValue = fieldEncodedValue;
        }

        @Override
        public FieldReference getValue() {
            return EncodedValueRewriter.this.rewriters.getFieldReferenceRewriter().rewrite(this.fieldEncodedValue.getValue());
        }
    }

    protected class RewrittenTypeEncodedValue
    extends BaseTypeEncodedValue {
        protected TypeEncodedValue typeEncodedValue;

        public RewrittenTypeEncodedValue(TypeEncodedValue typeEncodedValue) {
            this.typeEncodedValue = typeEncodedValue;
        }

        @Override
        public String getValue() {
            return EncodedValueRewriter.this.rewriters.getTypeRewriter().rewrite(this.typeEncodedValue.getValue());
        }
    }
}

