/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseFieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.AnnotationsDirectory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.StaticInitialValueIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Field;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import java.util.Set;

public class DexBackedField
extends BaseFieldReference
implements Field {
    public final DexBackedDexFile dexFile;
    public final ClassDef classDef;
    public final int accessFlags;
    public final EncodedValue initialValue;
    public final int annotationSetOffset;
    public final int fieldIndex;
    private final int startOffset;
    private final int initialValueOffset;
    private int fieldIdItemOffset;

    public DexBackedField(DexReader dexReader, DexBackedClassDef dexBackedClassDef, int n, StaticInitialValueIterator staticInitialValueIterator, AnnotationsDirectory.AnnotationIterator annotationIterator) {
        this.dexFile = (DexBackedDexFile)dexReader.dexBuf;
        this.classDef = dexBackedClassDef;
        this.startOffset = dexReader.getOffset();
        int n2 = dexReader.readLargeUleb128();
        this.fieldIndex = n2 + n;
        this.accessFlags = dexReader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValueOffset = staticInitialValueIterator.getReaderOffset();
        this.initialValue = staticInitialValueIterator.getNextOrNull();
    }

    public DexBackedField(DexReader dexReader, DexBackedClassDef dexBackedClassDef, int n, AnnotationsDirectory.AnnotationIterator annotationIterator) {
        this.dexFile = (DexBackedDexFile)dexReader.dexBuf;
        this.classDef = dexBackedClassDef;
        this.startOffset = dexReader.getOffset();
        int n2 = dexReader.readLargeUleb128();
        this.fieldIndex = n2 + n;
        this.accessFlags = dexReader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValueOffset = 0;
        this.initialValue = null;
    }

    @Override
    public String getName() {
        return this.dexFile.getString(this.dexFile.readSmallUint(this.getFieldIdItemOffset() + 4));
    }

    @Override
    public String getType() {
        return this.dexFile.getType(this.dexFile.readUshort(this.getFieldIdItemOffset() + 2));
    }

    @Override
    public String getDefiningClass() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public EncodedValue getInitialValue() {
        return this.initialValue;
    }

    public Set<? extends DexBackedAnnotation> getAnnotations() {
        return AnnotationsDirectory.getAnnotations(this.dexFile, this.annotationSetOffset);
    }

    public static void skipFields(DexReader dexReader, int n) {
        for (int i = 0; i < n; ++i) {
            dexReader.skipUleb128();
            dexReader.skipUleb128();
        }
    }

    private int getFieldIdItemOffset() {
        if (this.fieldIdItemOffset == 0) {
            this.fieldIdItemOffset = this.dexFile.getFieldIdItemOffset(this.fieldIndex);
        }
        return this.fieldIdItemOffset;
    }
}

