/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.TypeListSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.BaseNullableOffsetPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.DexPool;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.TypePool;
import java.util.Collection;
import java.util.Iterator;

public class TypeListPool
extends BaseNullableOffsetPool<Key<? extends Collection<? extends CharSequence>>>
implements TypeListSection<CharSequence, Key<? extends Collection<? extends CharSequence>>> {
    public TypeListPool(DexPool dexPool) {
        super(dexPool);
    }

    public void intern(Collection<? extends CharSequence> collection) {
        Key<Collection<? extends CharSequence>> key;
        Integer n;
        if (collection.size() > 0 && (n = this.internedItems.put(key = new Key<Collection<? extends CharSequence>>(collection), 0)) == null) {
            for (CharSequence charSequence : collection) {
                ((TypePool)this.dexPool.typeSection).intern(charSequence);
            }
        }
    }

    @Override
    public Collection<? extends CharSequence> getTypes(Key<? extends Collection<? extends CharSequence>> key) {
        if (key == null) {
            return ImmutableList.of();
        }
        return key.types;
    }

    @Override
    public int getNullableItemOffset(Key<? extends Collection<? extends CharSequence>> key) {
        if (key == null || key.types.size() == 0) {
            return 0;
        }
        return super.getNullableItemOffset(key);
    }

    public static class Key<TypeCollection extends Collection<? extends CharSequence>>
    implements Comparable<Key<? extends Collection<? extends CharSequence>>> {
        TypeCollection types;

        public Key(TypeCollection TypeCollection) {
            this.types = TypeCollection;
        }

        public int hashCode() {
            int n = 1;
            for (CharSequence charSequence : this.types) {
                n = n * 31 + charSequence.toString().hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                if (this.types.size() != key.types.size()) {
                    return false;
                }
                Iterator iterator = key.types.iterator();
                for (CharSequence charSequence : this.types) {
                    if (charSequence.toString().equals(((CharSequence)iterator.next()).toString())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (CharSequence charSequence : this.types) {
                stringBuilder.append(charSequence.toString());
            }
            return stringBuilder.toString();
        }

        @Override
        public int compareTo(Key<? extends Collection<? extends CharSequence>> key) {
            Iterator iterator = key.types.iterator();
            for (CharSequence charSequence : this.types) {
                if (!iterator.hasNext()) {
                    return 1;
                }
                int n = charSequence.toString().compareTo(((CharSequence)iterator.next()).toString());
                if (n == 0) continue;
                return n;
            }
            if (iterator.hasNext()) {
                return -1;
            }
            return 0;
        }
    }
}

