/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35ms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction35ms
extends ImmutableInstruction
implements Instruction35ms {
    public static final Format FORMAT = Format.Format35ms;
    protected final int registerCount;
    protected final int registerC;
    protected final int registerD;
    protected final int registerE;
    protected final int registerF;
    protected final int registerG;
    protected final int vtableIndex;

    public ImmutableInstruction35ms(Opcode opcode, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(opcode);
        this.registerCount = Preconditions.check35cAnd45ccRegisterCount(n);
        this.registerC = n > 0 ? Preconditions.checkNibbleRegister(n2) : 0;
        this.registerD = n > 1 ? Preconditions.checkNibbleRegister(n3) : 0;
        this.registerE = n > 2 ? Preconditions.checkNibbleRegister(n4) : 0;
        this.registerF = n > 3 ? Preconditions.checkNibbleRegister(n5) : 0;
        this.registerG = n > 4 ? Preconditions.checkNibbleRegister(n6) : 0;
        this.vtableIndex = Preconditions.checkVtableIndex(n7);
    }

    public static ImmutableInstruction35ms of(Instruction35ms instruction35ms) {
        if (instruction35ms instanceof ImmutableInstruction35ms) {
            return (ImmutableInstruction35ms)instruction35ms;
        }
        return new ImmutableInstruction35ms(instruction35ms.getOpcode(), instruction35ms.getRegisterCount(), instruction35ms.getRegisterC(), instruction35ms.getRegisterD(), instruction35ms.getRegisterE(), instruction35ms.getRegisterF(), instruction35ms.getRegisterG(), instruction35ms.getVtableIndex());
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    @Override
    public int getRegisterC() {
        return this.registerC;
    }

    @Override
    public int getRegisterD() {
        return this.registerD;
    }

    @Override
    public int getRegisterE() {
        return this.registerE;
    }

    @Override
    public int getRegisterF() {
        return this.registerF;
    }

    @Override
    public int getRegisterG() {
        return this.registerG;
    }

    @Override
    public int getVtableIndex() {
        return this.vtableIndex;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

