/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction22s
extends ImmutableInstruction
implements Instruction22s {
    public static final Format FORMAT = Format.Format22s;
    protected final int registerA;
    protected final int registerB;
    protected final int literal;

    public ImmutableInstruction22s(Opcode opcode, int n, int n2, int n3) {
        super(opcode);
        this.registerA = Preconditions.checkNibbleRegister(n);
        this.registerB = Preconditions.checkNibbleRegister(n2);
        this.literal = Preconditions.checkShortLiteral(n3);
    }

    public static ImmutableInstruction22s of(Instruction22s instruction22s) {
        if (instruction22s instanceof ImmutableInstruction22s) {
            return (ImmutableInstruction22s)instruction22s;
        }
        return new ImmutableInstruction22s(instruction22s.getOpcode(), instruction22s.getRegisterA(), instruction22s.getRegisterB(), instruction22s.getNarrowLiteral());
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    @Override
    public int getNarrowLiteral() {
        return this.literal;
    }

    @Override
    public long getWideLiteral() {
        return this.literal;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

