/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Ordering;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.BaseAnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.AnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.FieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.AnnotationSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.DexDataWriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.FieldSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.MethodSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.StringSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.TypeSection;
import java.io.IOException;
import java.util.Collection;

public abstract class EncodedValueWriter<StringKey, TypeKey, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference, AnnotationElement extends AnnotationElement, EncodedValue> {
    private final DexDataWriter writer;
    private final StringSection<StringKey, ?> stringSection;
    private final TypeSection<?, TypeKey, ?> typeSection;
    private final FieldSection<?, ?, FieldRefKey, ?> fieldSection;
    private final MethodSection<?, ?, ?, MethodRefKey, ?> methodSection;
    private final AnnotationSection<StringKey, TypeKey, ?, AnnotationElement, EncodedValue> annotationSection;

    public EncodedValueWriter(DexDataWriter dexDataWriter, StringSection<StringKey, ?> stringSection, TypeSection<?, TypeKey, ?> typeSection, FieldSection<?, ?, FieldRefKey, ?> fieldSection, MethodSection<?, ?, ?, MethodRefKey, ?> methodSection, AnnotationSection<StringKey, TypeKey, ?, AnnotationElement, EncodedValue> annotationSection) {
        this.writer = dexDataWriter;
        this.stringSection = stringSection;
        this.typeSection = typeSection;
        this.fieldSection = fieldSection;
        this.methodSection = methodSection;
        this.annotationSection = annotationSection;
    }

    protected abstract void writeEncodedValue(EncodedValue var1) throws IOException;

    public void writeAnnotation(TypeKey TypeKey, Collection<? extends AnnotationElement> collection) throws IOException {
        this.writer.writeEncodedValueHeader(29, 0);
        this.writer.writeUleb128(this.typeSection.getItemIndex(TypeKey));
        this.writer.writeUleb128(collection.size());
        ImmutableList<AnnotationElement> immutableList = Ordering.from(BaseAnnotationElement.BY_NAME).immutableSortedCopy(collection);
        for (AnnotationElement annotationElement : immutableList) {
            this.writer.writeUleb128(this.stringSection.getItemIndex(this.annotationSection.getElementName(annotationElement)));
            this.writeEncodedValue(this.annotationSection.getElementValue(annotationElement));
        }
    }

    public void writeArray(Collection<? extends EncodedValue> collection) throws IOException {
        this.writer.writeEncodedValueHeader(28, 0);
        this.writer.writeUleb128(collection.size());
        for (EncodedValue EncodedValue2 : collection) {
            this.writeEncodedValue(EncodedValue2);
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.writer.writeEncodedValueHeader(31, bl ? 1 : 0);
    }

    public void writeByte(byte by) throws IOException {
        this.writer.writeEncodedInt(0, by);
    }

    public void writeChar(char c) throws IOException {
        this.writer.writeEncodedUint(3, c);
    }

    public void writeDouble(double d) throws IOException {
        this.writer.writeEncodedDouble(17, d);
    }

    public void writeEnum(FieldRefKey FieldRefKey) throws IOException {
        this.writer.writeEncodedUint(27, this.fieldSection.getItemIndex(FieldRefKey));
    }

    public void writeField(FieldRefKey FieldRefKey) throws IOException {
        this.writer.writeEncodedUint(25, this.fieldSection.getItemIndex(FieldRefKey));
    }

    public void writeFloat(float f) throws IOException {
        this.writer.writeEncodedFloat(16, f);
    }

    public void writeInt(int n) throws IOException {
        this.writer.writeEncodedInt(4, n);
    }

    public void writeLong(long l) throws IOException {
        this.writer.writeEncodedLong(6, l);
    }

    public void writeMethod(MethodRefKey MethodRefKey) throws IOException {
        this.writer.writeEncodedUint(26, this.methodSection.getItemIndex(MethodRefKey));
    }

    public void writeNull() throws IOException {
        this.writer.write(30);
    }

    public void writeShort(int n) throws IOException {
        this.writer.writeEncodedInt(2, n);
    }

    public void writeString(StringKey StringKey) throws IOException {
        this.writer.writeEncodedUint(23, this.stringSection.getItemIndex(StringKey));
    }

    public void writeType(TypeKey TypeKey) throws IOException {
        this.writer.writeEncodedUint(24, this.typeSection.getItemIndex(TypeKey));
    }
}

