/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.Reference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.reference.ImmutableReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.reference.ImmutableReferenceFactory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction3rc
extends ImmutableInstruction
implements Instruction3rc {
    public static final Format FORMAT = Format.Format3rc;
    protected final int startRegister;
    protected final int registerCount;
    protected final ImmutableReference reference;

    public ImmutableInstruction3rc(Opcode opcode, int n, int n2, Reference reference) {
        super(opcode);
        this.startRegister = Preconditions.checkShortRegister(n);
        this.registerCount = Preconditions.checkRegisterRangeCount(n2);
        this.reference = ImmutableReferenceFactory.of(opcode.referenceType, reference);
    }

    public static ImmutableInstruction3rc of(Instruction3rc instruction3rc) {
        if (instruction3rc instanceof ImmutableInstruction3rc) {
            return (ImmutableInstruction3rc)instruction3rc;
        }
        return new ImmutableInstruction3rc(instruction3rc.getOpcode(), instruction3rc.getStartRegister(), instruction3rc.getRegisterCount(), instruction3rc.getReference());
    }

    @Override
    public int getStartRegister() {
        return this.startRegister;
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    @Override
    public ImmutableReference getReference() {
        return this.reference;
    }

    @Override
    public int getReferenceType() {
        return this.opcode.referenceType;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

