/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedMethod;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedTryBlock;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.DebugInfo;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.VariableSizeLookaheadIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.MethodImplementation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.DebugItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.AlignmentUtils;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.util.Iterator;
import java.util.List;

public class DexBackedMethodImplementation
implements MethodImplementation {
    public final DexBackedDexFile dexFile;
    public final DexBackedMethod method;
    private final int codeOffset;

    public DexBackedMethodImplementation(DexBackedDexFile dexBackedDexFile, DexBackedMethod dexBackedMethod, int n) {
        this.dexFile = dexBackedDexFile;
        this.method = dexBackedMethod;
        this.codeOffset = n;
    }

    @Override
    public int getRegisterCount() {
        return this.dexFile.readUshort(this.codeOffset);
    }

    @Override
    public Iterable<? extends Instruction> getInstructions() {
        int n = this.dexFile.readSmallUint(this.codeOffset + 12);
        final int n2 = this.codeOffset + 16;
        final int n3 = n2 + n * 2;
        return new Iterable<Instruction>(){

            @Override
            public Iterator<Instruction> iterator() {
                return new VariableSizeLookaheadIterator<Instruction>(DexBackedMethodImplementation.this.dexFile, n2){

                    @Override
                    protected Instruction readNextItem(DexReader dexReader) {
                        if (dexReader.getOffset() >= n3) {
                            return (Instruction)this.endOfData();
                        }
                        Instruction instruction = DexBackedInstruction.readFrom(dexReader);
                        int n = dexReader.getOffset();
                        if (n > n3 || n < 0) {
                            throw new ExceptionWithContext("The last instruction in method %s is truncated", DexBackedMethodImplementation.this.method);
                        }
                        return instruction;
                    }
                };
            }
        };
    }

    public List<? extends DexBackedTryBlock> getTryBlocks() {
        final int n = this.dexFile.readUshort(this.codeOffset + 6);
        if (n > 0) {
            int n2 = this.dexFile.readSmallUint(this.codeOffset + 12);
            final int n3 = AlignmentUtils.alignOffset(this.codeOffset + 16 + n2 * 2, 4);
            final int n4 = n3 + n * 8;
            return new FixedSizeList<DexBackedTryBlock>(){

                @Override
                public DexBackedTryBlock readItem(int n2) {
                    return new DexBackedTryBlock(DexBackedMethodImplementation.this.dexFile, n3 + n2 * 8, n4);
                }

                @Override
                public int size() {
                    return n;
                }
            };
        }
        return ImmutableList.of();
    }

    private DebugInfo getDebugInfo() {
        int n = this.dexFile.readInt(this.codeOffset + 8);
        if (n == -1 || n == 0) {
            return DebugInfo.newOrEmpty(this.dexFile, 0, this);
        }
        if (n < 0) {
            System.err.println(String.format("%s: Invalid debug offset", this.method));
            return DebugInfo.newOrEmpty(this.dexFile, 0, this);
        }
        if (n >= this.dexFile.buf.length) {
            System.err.println(String.format("%s: Invalid debug offset", this.method));
            return DebugInfo.newOrEmpty(this.dexFile, 0, this);
        }
        return DebugInfo.newOrEmpty(this.dexFile, n, this);
    }

    @Override
    public Iterable<? extends DebugItem> getDebugItems() {
        return this.getDebugInfo();
    }

    public Iterator<String> getParameterNames(DexReader dexReader) {
        return this.getDebugInfo().getParameterNames(dexReader);
    }
}

